/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.api;

import com.google.gson.reflect.TypeToken;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.model.BlockInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.StatementsDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class BlockRoutesApi {
    private ApiClient localVarApiClient;

    public BlockRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BlockRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getBlockByHeightCall(Long height, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/block/{height}".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBlockByHeightValidateBeforeCall(Long height, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockByHeight(Async)");
        }
        Call localVarCall = this.getBlockByHeightCall(height, _callback);
        return localVarCall;
    }

    public BlockInfoDTO getBlockByHeight(Long height) throws ApiException {
        ApiResponse<BlockInfoDTO> localVarResp = this.getBlockByHeightWithHttpInfo(height);
        return localVarResp.getData();
    }

    public ApiResponse<BlockInfoDTO> getBlockByHeightWithHttpInfo(Long height) throws ApiException {
        Call localVarCall = this.getBlockByHeightValidateBeforeCall(height, null);
        Type localVarReturnType = new TypeToken<BlockInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBlockByHeightAsync(Long height, ApiCallback<BlockInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getBlockByHeightValidateBeforeCall(height, _callback);
        Type localVarReturnType = new TypeToken<BlockInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBlockReceiptsCall(Long height, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/block/{height}/receipts".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBlockReceiptsValidateBeforeCall(Long height, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockReceipts(Async)");
        }
        Call localVarCall = this.getBlockReceiptsCall(height, _callback);
        return localVarCall;
    }

    public StatementsDTO getBlockReceipts(Long height) throws ApiException {
        ApiResponse<StatementsDTO> localVarResp = this.getBlockReceiptsWithHttpInfo(height);
        return localVarResp.getData();
    }

    public ApiResponse<StatementsDTO> getBlockReceiptsWithHttpInfo(Long height) throws ApiException {
        Call localVarCall = this.getBlockReceiptsValidateBeforeCall(height, null);
        Type localVarReturnType = new TypeToken<StatementsDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBlockReceiptsAsync(Long height, ApiCallback<StatementsDTO> _callback) throws ApiException {
        Call localVarCall = this.getBlockReceiptsValidateBeforeCall(height, _callback);
        Type localVarReturnType = new TypeToken<StatementsDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBlockTransactionsCall(Long height, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/block/{height}/transactions".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBlockTransactionsValidateBeforeCall(Long height, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockTransactions(Async)");
        }
        Call localVarCall = this.getBlockTransactionsCall(height, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> getBlockTransactions(Long height, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.getBlockTransactionsWithHttpInfo(height, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getBlockTransactionsWithHttpInfo(Long height, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.getBlockTransactionsValidateBeforeCall(height, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBlockTransactionsAsync(Long height, Integer pageSize, String id, String ordering, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getBlockTransactionsValidateBeforeCall(height, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBlocksByHeightWithLimitCall(Long height, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/blocks/{height}/limit/{limit}".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString())).replaceAll("\\{limit\\}", this.localVarApiClient.escapeString(limit.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBlocksByHeightWithLimitValidateBeforeCall(Long height, Integer limit, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlocksByHeightWithLimit(Async)");
        }
        if (limit == null) {
            throw new ApiException("Missing the required parameter 'limit' when calling getBlocksByHeightWithLimit(Async)");
        }
        Call localVarCall = this.getBlocksByHeightWithLimitCall(height, limit, _callback);
        return localVarCall;
    }

    public List<BlockInfoDTO> getBlocksByHeightWithLimit(Long height, Integer limit) throws ApiException {
        ApiResponse<List<BlockInfoDTO>> localVarResp = this.getBlocksByHeightWithLimitWithHttpInfo(height, limit);
        return localVarResp.getData();
    }

    public ApiResponse<List<BlockInfoDTO>> getBlocksByHeightWithLimitWithHttpInfo(Long height, Integer limit) throws ApiException {
        Call localVarCall = this.getBlocksByHeightWithLimitValidateBeforeCall(height, limit, null);
        Type localVarReturnType = new TypeToken<List<BlockInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBlocksByHeightWithLimitAsync(Long height, Integer limit, ApiCallback<List<BlockInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getBlocksByHeightWithLimitValidateBeforeCall(height, limit, _callback);
        Type localVarReturnType = new TypeToken<List<BlockInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMerkleReceiptsCall(Long height, String hash, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/block/{height}/receipt/{hash}/merkle".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString())).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMerkleReceiptsValidateBeforeCall(Long height, String hash, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getMerkleReceipts(Async)");
        }
        if (hash == null) {
            throw new ApiException("Missing the required parameter 'hash' when calling getMerkleReceipts(Async)");
        }
        Call localVarCall = this.getMerkleReceiptsCall(height, hash, _callback);
        return localVarCall;
    }

    public MerkleProofInfoDTO getMerkleReceipts(Long height, String hash) throws ApiException {
        ApiResponse<MerkleProofInfoDTO> localVarResp = this.getMerkleReceiptsWithHttpInfo(height, hash);
        return localVarResp.getData();
    }

    public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(Long height, String hash) throws ApiException {
        Call localVarCall = this.getMerkleReceiptsValidateBeforeCall(height, hash, null);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMerkleReceiptsAsync(Long height, String hash, ApiCallback<MerkleProofInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getMerkleReceiptsValidateBeforeCall(height, hash, _callback);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMerkleTransactionCall(Long height, String hash, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/block/{height}/transaction/{hash}/merkle".replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString())).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMerkleTransactionValidateBeforeCall(Long height, String hash, ApiCallback _callback) throws ApiException {
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getMerkleTransaction(Async)");
        }
        if (hash == null) {
            throw new ApiException("Missing the required parameter 'hash' when calling getMerkleTransaction(Async)");
        }
        Call localVarCall = this.getMerkleTransactionCall(height, hash, _callback);
        return localVarCall;
    }

    public MerkleProofInfoDTO getMerkleTransaction(Long height, String hash) throws ApiException {
        ApiResponse<MerkleProofInfoDTO> localVarResp = this.getMerkleTransactionWithHttpInfo(height, hash);
        return localVarResp.getData();
    }

    public ApiResponse<MerkleProofInfoDTO> getMerkleTransactionWithHttpInfo(Long height, String hash) throws ApiException {
        Call localVarCall = this.getMerkleTransactionValidateBeforeCall(height, hash, null);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMerkleTransactionAsync(Long height, String hash, ApiCallback<MerkleProofInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getMerkleTransactionValidateBeforeCall(height, hash, _callback);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

