/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.okhttp_gson.api;

import com.google.gson.reflect.TypeToken;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountsNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountGraphInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AccountRoutesApi {
    private ApiClient localVarApiClient;

    public AccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAccountInfoCall(String accountId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountInfoValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountInfo(Async)");
        }
        Call localVarCall = this.getAccountInfoCall(accountId, _callback);
        return localVarCall;
    }

    public AccountInfoDTO getAccountInfo(String accountId) throws ApiException {
        ApiResponse<AccountInfoDTO> localVarResp = this.getAccountInfoWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    public ApiResponse<AccountInfoDTO> getAccountInfoWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.getAccountInfoValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountInfoAsync(String accountId, ApiCallback<AccountInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getAccountInfoValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountMultisigCall(String accountId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/multisig".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountMultisigValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMultisig(Async)");
        }
        Call localVarCall = this.getAccountMultisigCall(accountId, _callback);
        return localVarCall;
    }

    public MultisigAccountInfoDTO getAccountMultisig(String accountId) throws ApiException {
        ApiResponse<MultisigAccountInfoDTO> localVarResp = this.getAccountMultisigWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    public ApiResponse<MultisigAccountInfoDTO> getAccountMultisigWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.getAccountMultisigValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<MultisigAccountInfoDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountMultisigAsync(String accountId, ApiCallback<MultisigAccountInfoDTO> _callback) throws ApiException {
        Call localVarCall = this.getAccountMultisigValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<MultisigAccountInfoDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountMultisigGraphCall(String accountId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/multisig/graph".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountMultisigGraphValidateBeforeCall(String accountId, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMultisigGraph(Async)");
        }
        Call localVarCall = this.getAccountMultisigGraphCall(accountId, _callback);
        return localVarCall;
    }

    public List<MultisigAccountGraphInfoDTO> getAccountMultisigGraph(String accountId) throws ApiException {
        ApiResponse<List<MultisigAccountGraphInfoDTO>> localVarResp = this.getAccountMultisigGraphWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    public ApiResponse<List<MultisigAccountGraphInfoDTO>> getAccountMultisigGraphWithHttpInfo(String accountId) throws ApiException {
        Call localVarCall = this.getAccountMultisigGraphValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<MultisigAccountGraphInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountMultisigGraphAsync(String accountId, ApiCallback<List<MultisigAccountGraphInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountMultisigGraphValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<MultisigAccountGraphInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountsInfoCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountsInfoValidateBeforeCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAccountsInfoCall(accountIds, _callback);
        return localVarCall;
    }

    public List<AccountInfoDTO> getAccountsInfo(AccountIds accountIds) throws ApiException {
        ApiResponse<List<AccountInfoDTO>> localVarResp = this.getAccountsInfoWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    public ApiResponse<List<AccountInfoDTO>> getAccountsInfoWithHttpInfo(AccountIds accountIds) throws ApiException {
        Call localVarCall = this.getAccountsInfoValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountsInfoAsync(AccountIds accountIds, ApiCallback<List<AccountInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.getAccountsInfoValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAccountsNamesCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountsNamesValidateBeforeCall(AccountIds accountIds, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAccountsNamesCall(accountIds, _callback);
        return localVarCall;
    }

    public AccountsNamesDTO getAccountsNames(AccountIds accountIds) throws ApiException {
        ApiResponse<AccountsNamesDTO> localVarResp = this.getAccountsNamesWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    public ApiResponse<AccountsNamesDTO> getAccountsNamesWithHttpInfo(AccountIds accountIds) throws ApiException {
        Call localVarCall = this.getAccountsNamesValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<AccountsNamesDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAccountsNamesAsync(AccountIds accountIds, ApiCallback<AccountsNamesDTO> _callback) throws ApiException {
        Call localVarCall = this.getAccountsNamesValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<AccountsNamesDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call incomingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/incoming".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call incomingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling incomingTransactions(Async)");
        }
        Call localVarCall = this.incomingTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> incomingTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.incomingTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> incomingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.incomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call incomingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.incomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call outgoingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/outgoing".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call outgoingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling outgoingTransactions(Async)");
        }
        Call localVarCall = this.outgoingTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> outgoingTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.outgoingTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> outgoingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.outgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call outgoingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.outgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call partialTransactionsCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/partial".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call partialTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling partialTransactions(Async)");
        }
        Call localVarCall = this.partialTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> partialTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.partialTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> partialTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.partialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call partialTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.partialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call transactionsCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling transactions(Async)");
        }
        Call localVarCall = this.transactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> transactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.transactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> transactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.transactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call transactionsAsync(String accountId, Integer pageSize, String id, String ordering, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.transactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unconfirmedTransactionsCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();
        String localVarPath = "/account/{accountId}/transactions/unconfirmed".replaceAll("\\{accountId\\}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (ordering != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ordering", ordering));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unconfirmedTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling unconfirmedTransactions(Async)");
        }
        Call localVarCall = this.unconfirmedTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;
    }

    public List<TransactionInfoDTO> unconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = this.unconfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> unconfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        Call localVarCall = this.unconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call unconfirmedTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {
        Call localVarCall = this.unconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

