/*
 * Catapult REST Endpoints
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.7.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.BlockInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;
import io.nem.sdk.openapi.okhttp_gson.model.StatementsDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockRoutesApi {
    private ApiClient localVarApiClient;

    public BlockRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BlockRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getBlockByHeight
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlockByHeightCall(Long height, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/block/{height}"
            .replaceAll("\\{" + "height" + "\\}", localVarApiClient.escapeString(height.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBlockByHeightValidateBeforeCall(Long height, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'height' is set
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockByHeight(Async)");
        }
        

        okhttp3.Call localVarCall = getBlockByHeightCall(height, _callback);
        return localVarCall;

    }

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @return BlockInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public BlockInfoDTO getBlockByHeight(Long height) throws ApiException {
        ApiResponse<BlockInfoDTO> localVarResp = getBlockByHeightWithHttpInfo(height);
        return localVarResp.getData();
    }

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @return ApiResponse&lt;BlockInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BlockInfoDTO> getBlockByHeightWithHttpInfo(Long height) throws ApiException {
        okhttp3.Call localVarCall = getBlockByHeightValidateBeforeCall(height, null);
        Type localVarReturnType = new TypeToken<BlockInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get block information (asynchronously)
     * Gets a block from the chain that has the given height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlockByHeightAsync(Long height, final ApiCallback<BlockInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBlockByHeightValidateBeforeCall(height, _callback);
        Type localVarReturnType = new TypeToken<BlockInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBlockReceipts
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlockReceiptsCall(Long height, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/block/{height}/receipts"
            .replaceAll("\\{" + "height" + "\\}", localVarApiClient.escapeString(height.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBlockReceiptsValidateBeforeCall(Long height, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'height' is set
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockReceipts(Async)");
        }
        

        okhttp3.Call localVarCall = getBlockReceiptsCall(height, _callback);
        return localVarCall;

    }

    /**
     * Get receipts from a block
     * Returns the receipts linked to a block.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @return StatementsDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public StatementsDTO getBlockReceipts(Long height) throws ApiException {
        ApiResponse<StatementsDTO> localVarResp = getBlockReceiptsWithHttpInfo(height);
        return localVarResp.getData();
    }

    /**
     * Get receipts from a block
     * Returns the receipts linked to a block.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @return ApiResponse&lt;StatementsDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StatementsDTO> getBlockReceiptsWithHttpInfo(Long height) throws ApiException {
        okhttp3.Call localVarCall = getBlockReceiptsValidateBeforeCall(height, null);
        Type localVarReturnType = new TypeToken<StatementsDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get receipts from a block (asynchronously)
     * Returns the receipts linked to a block.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlockReceiptsAsync(Long height, final ApiCallback<StatementsDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBlockReceiptsValidateBeforeCall(height, _callback);
        Type localVarReturnType = new TypeToken<StatementsDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBlockTransactions
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlockTransactionsCall(Long height, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/block/{height}/transactions"
            .replaceAll("\\{" + "height" + "\\}", localVarApiClient.escapeString(height.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBlockTransactionsValidateBeforeCall(Long height, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'height' is set
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = getBlockTransactionsCall(height, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get transactions from a block
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> getBlockTransactions(Long height, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = getBlockTransactionsWithHttpInfo(height, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get transactions from a block
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> getBlockTransactionsWithHttpInfo(Long height, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = getBlockTransactionsValidateBeforeCall(height, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get transactions from a block (asynchronously)
     * Returns an array of transactions included in a block for a given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlockTransactionsAsync(Long height, Integer pageSize, String id, String ordering, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBlockTransactionsValidateBeforeCall(height, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBlocksByHeightWithLimit
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param limit Number of elements to be returned. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlocksByHeightWithLimitCall(Long height, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/blocks/{height}/limit/{limit}"
            .replaceAll("\\{" + "height" + "\\}", localVarApiClient.escapeString(height.toString()))
            .replaceAll("\\{" + "limit" + "\\}", localVarApiClient.escapeString(limit.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBlocksByHeightWithLimitValidateBeforeCall(Long height, Integer limit, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'height' is set
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlocksByHeightWithLimit(Async)");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new ApiException("Missing the required parameter 'limit' when calling getBlocksByHeightWithLimit(Async)");
        }
        

        okhttp3.Call localVarCall = getBlocksByHeightWithLimitCall(height, limit, _callback);
        return localVarCall;

    }

    /**
     * Get blocks information
     * Gets up to limit number of blocks after given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param limit Number of elements to be returned. (required)
     * @return List&lt;BlockInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<BlockInfoDTO> getBlocksByHeightWithLimit(Long height, Integer limit) throws ApiException {
        ApiResponse<List<BlockInfoDTO>> localVarResp = getBlocksByHeightWithLimitWithHttpInfo(height, limit);
        return localVarResp.getData();
    }

    /**
     * Get blocks information
     * Gets up to limit number of blocks after given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param limit Number of elements to be returned. (required)
     * @return ApiResponse&lt;List&lt;BlockInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<BlockInfoDTO>> getBlocksByHeightWithLimitWithHttpInfo(Long height, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = getBlocksByHeightWithLimitValidateBeforeCall(height, limit, null);
        Type localVarReturnType = new TypeToken<List<BlockInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get blocks information (asynchronously)
     * Gets up to limit number of blocks after given block height.
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param limit Number of elements to be returned. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlocksByHeightWithLimitAsync(Long height, Integer limit, final ApiCallback<List<BlockInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBlocksByHeightWithLimitValidateBeforeCall(height, limit, _callback);
        Type localVarReturnType = new TypeToken<List<BlockInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMerkleReceipts
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Receipt hash. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMerkleReceiptsCall(Long height, String hash, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/block/{height}/receipt/{hash}/merkle"
            .replaceAll("\\{" + "height" + "\\}", localVarApiClient.escapeString(height.toString()))
            .replaceAll("\\{" + "hash" + "\\}", localVarApiClient.escapeString(hash.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMerkleReceiptsValidateBeforeCall(Long height, String hash, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'height' is set
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getMerkleReceipts(Async)");
        }
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            throw new ApiException("Missing the required parameter 'hash' when calling getMerkleReceipts(Async)");
        }
        

        okhttp3.Call localVarCall = getMerkleReceiptsCall(height, hash, _callback);
        return localVarCall;

    }

    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Receipt hash. (required)
     * @return MerkleProofInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MerkleProofInfoDTO getMerkleReceipts(Long height, String hash) throws ApiException {
        ApiResponse<MerkleProofInfoDTO> localVarResp = getMerkleReceiptsWithHttpInfo(height, hash);
        return localVarResp.getData();
    }

    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Receipt hash. (required)
     * @return ApiResponse&lt;MerkleProofInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(Long height, String hash) throws ApiException {
        okhttp3.Call localVarCall = getMerkleReceiptsValidateBeforeCall(height, hash, null);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the merkle path for a given a receipt statement hash and block (asynchronously)
     * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Receipt hash. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMerkleReceiptsAsync(Long height, String hash, final ApiCallback<MerkleProofInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMerkleReceiptsValidateBeforeCall(height, hash, _callback);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getMerkleTransaction
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Transaction hash. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMerkleTransactionCall(Long height, String hash, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/block/{height}/transaction/{hash}/merkle"
            .replaceAll("\\{" + "height" + "\\}", localVarApiClient.escapeString(height.toString()))
            .replaceAll("\\{" + "hash" + "\\}", localVarApiClient.escapeString(hash.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMerkleTransactionValidateBeforeCall(Long height, String hash, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'height' is set
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getMerkleTransaction(Async)");
        }
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            throw new ApiException("Missing the required parameter 'hash' when calling getMerkleTransaction(Async)");
        }
        

        okhttp3.Call localVarCall = getMerkleTransactionCall(height, hash, _callback);
        return localVarCall;

    }

    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the transaction was included in the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Transaction hash. (required)
     * @return MerkleProofInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MerkleProofInfoDTO getMerkleTransaction(Long height, String hash) throws ApiException {
        ApiResponse<MerkleProofInfoDTO> localVarResp = getMerkleTransactionWithHttpInfo(height, hash);
        return localVarResp.getData();
    }

    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the transaction was included in the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Transaction hash. (required)
     * @return ApiResponse&lt;MerkleProofInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MerkleProofInfoDTO> getMerkleTransactionWithHttpInfo(Long height, String hash) throws ApiException {
        okhttp3.Call localVarCall = getMerkleTransactionValidateBeforeCall(height, hash, null);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the merkle path for a given a transaction and block (asynchronously)
     * Returns the merkle path for a transaction included in a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the transaction was included in the block. 
     * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
     * @param hash Transaction hash. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMerkleTransactionAsync(Long height, String hash, final ApiCallback<MerkleProofInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getMerkleTransactionValidateBeforeCall(height, hash, _callback);
        Type localVarReturnType = new TypeToken<MerkleProofInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
