/*
 * Catapult REST Endpoints
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 0.7.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.sdk.openapi.okhttp_gson.api;

import io.nem.sdk.openapi.okhttp_gson.invoker.ApiCallback;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiResponse;
import io.nem.sdk.openapi.okhttp_gson.invoker.Configuration;
import io.nem.sdk.openapi.okhttp_gson.invoker.Pair;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressRequestBody;
import io.nem.sdk.openapi.okhttp_gson.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountsNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.ModelError;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountGraphInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountRoutesApi {
    private ApiClient localVarApiClient;

    public AccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountRoutesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAccountInfo
     * @param accountId Account public key or address. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountInfoCall(String accountId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountInfoValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountInfo(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountInfoCall(accountId, _callback);
        return localVarCall;

    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address. (required)
     * @return AccountInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AccountInfoDTO getAccountInfo(String accountId) throws ApiException {
        ApiResponse<AccountInfoDTO> localVarResp = getAccountInfoWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address. (required)
     * @return ApiResponse&lt;AccountInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountInfoDTO> getAccountInfoWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getAccountInfoValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get account information (asynchronously)
     * Returns the account information.
     * @param accountId Account public key or address. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountInfoAsync(String accountId, final ApiCallback<AccountInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountInfoValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<AccountInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountMultisig
     * @param accountId Account public key or address. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMultisigCall(String accountId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/multisig"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountMultisigValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMultisig(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountMultisigCall(accountId, _callback);
        return localVarCall;

    }

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param accountId Account public key or address. (required)
     * @return MultisigAccountInfoDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public MultisigAccountInfoDTO getAccountMultisig(String accountId) throws ApiException {
        ApiResponse<MultisigAccountInfoDTO> localVarResp = getAccountMultisigWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param accountId Account public key or address. (required)
     * @return ApiResponse&lt;MultisigAccountInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MultisigAccountInfoDTO> getAccountMultisigWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getAccountMultisigValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<MultisigAccountInfoDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get multisig account information (asynchronously)
     * Returns the multisig account information.
     * @param accountId Account public key or address. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMultisigAsync(String accountId, final ApiCallback<MultisigAccountInfoDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountMultisigValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<MultisigAccountInfoDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountMultisigGraph
     * @param accountId Account public key or address. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMultisigGraphCall(String accountId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/multisig/graph"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountMultisigGraphValidateBeforeCall(String accountId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccountMultisigGraph(Async)");
        }
        

        okhttp3.Call localVarCall = getAccountMultisigGraphCall(accountId, _callback);
        return localVarCall;

    }

    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param accountId Account public key or address. (required)
     * @return List&lt;MultisigAccountGraphInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<MultisigAccountGraphInfoDTO> getAccountMultisigGraph(String accountId) throws ApiException {
        ApiResponse<List<MultisigAccountGraphInfoDTO>> localVarResp = getAccountMultisigGraphWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param accountId Account public key or address. (required)
     * @return ApiResponse&lt;List&lt;MultisigAccountGraphInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<MultisigAccountGraphInfoDTO>> getAccountMultisigGraphWithHttpInfo(String accountId) throws ApiException {
        okhttp3.Call localVarCall = getAccountMultisigGraphValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<MultisigAccountGraphInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get multisig account graph information (asynchronously)
     * Returns the multisig account graph.
     * @param accountId Account public key or address. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountMultisigGraphAsync(String accountId, final ApiCallback<List<MultisigAccountGraphInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountMultisigGraphValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<MultisigAccountGraphInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountsInfo
     * @param accountIds  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsInfoCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountIds;

        // create path and map variables
        String localVarPath = "/account";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountsInfoValidateBeforeCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAccountsInfoCall(accountIds, _callback);
        return localVarCall;

    }

    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @return List&lt;AccountInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<AccountInfoDTO> getAccountsInfo(AccountIds accountIds) throws ApiException {
        ApiResponse<List<AccountInfoDTO>> localVarResp = getAccountsInfoWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @return ApiResponse&lt;List&lt;AccountInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<AccountInfoDTO>> getAccountsInfoWithHttpInfo(AccountIds accountIds) throws ApiException {
        okhttp3.Call localVarCall = getAccountsInfoValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get accounts information (asynchronously)
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsInfoAsync(AccountIds accountIds, final ApiCallback<List<AccountInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountsInfoValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<List<AccountInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAccountsNames
     * @param accountIds  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsNamesCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = accountIds;

        // create path and map variables
        String localVarPath = "/account/names";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAccountsNamesValidateBeforeCall(AccountIds accountIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAccountsNamesCall(accountIds, _callback);
        return localVarCall;

    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @return AccountsNamesDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public AccountsNamesDTO getAccountsNames(AccountIds accountIds) throws ApiException {
        ApiResponse<AccountsNamesDTO> localVarResp = getAccountsNamesWithHttpInfo(accountIds);
        return localVarResp.getData();
    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @return ApiResponse&lt;AccountsNamesDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AccountsNamesDTO> getAccountsNamesWithHttpInfo(AccountIds accountIds) throws ApiException {
        okhttp3.Call localVarCall = getAccountsNamesValidateBeforeCall(accountIds, null);
        Type localVarReturnType = new TypeToken<AccountsNamesDTO>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get readable names for a set of accountIds (asynchronously)
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAccountsNamesAsync(AccountIds accountIds, final ApiCallback<AccountsNamesDTO> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAccountsNamesValidateBeforeCall(accountIds, _callback);
        Type localVarReturnType = new TypeToken<AccountsNamesDTO>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for incomingTransactions
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call incomingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/incoming"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call incomingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling incomingTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = incomingTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get incoming transactions
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> incomingTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = incomingTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get incoming transactions
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> incomingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = incomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get incoming transactions (asynchronously)
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call incomingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = incomingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for outgoingTransactions
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call outgoingTransactionsCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/outgoing"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call outgoingTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling outgoingTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = outgoingTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get outgoing transactions
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> outgoingTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = outgoingTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get outgoing transactions
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> outgoingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = outgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get outgoing transactions (asynchronously)
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call outgoingTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = outgoingTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for partialTransactions
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call partialTransactionsCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/partial"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call partialTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling partialTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = partialTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get aggregate bonded transactions information
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> partialTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = partialTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get aggregate bonded transactions information
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> partialTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = partialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get aggregate bonded transactions information (asynchronously)
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call partialTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = partialTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for transactions
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call transactionsCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call transactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling transactions(Async)");
        }
        

        okhttp3.Call localVarCall = transactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get confirmed transactions
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> transactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = transactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get confirmed transactions
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> transactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = transactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get confirmed transactions (asynchronously)
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call transactionsAsync(String accountId, Integer pageSize, String id, String ordering, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = transactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for unconfirmedTransactions
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call unconfirmedTransactionsCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/account/{accountId}/transactions/unconfirmed"
            .replaceAll("\\{" + "accountId" + "\\}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageSize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageSize", pageSize));
        }

        if (id != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("id", id));
        }

        if (ordering != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ordering", ordering));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call unconfirmedTransactionsValidateBeforeCall(String accountId, Integer pageSize, String id, String ordering, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling unconfirmedTransactions(Async)");
        }
        

        okhttp3.Call localVarCall = unconfirmedTransactionsCall(accountId, pageSize, id, ordering, _callback);
        return localVarCall;

    }

    /**
     * Get unconfirmed transactions
     * Gets the array of transactions not included in a block where an account is the sender or receiver. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return List&lt;TransactionInfoDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public List<TransactionInfoDTO> unconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        ApiResponse<List<TransactionInfoDTO>> localVarResp = unconfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering);
        return localVarResp.getData();
    }

    /**
     * Get unconfirmed transactions
     * Gets the array of transactions not included in a block where an account is the sender or receiver. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TransactionInfoDTO>> unconfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        okhttp3.Call localVarCall = unconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, null);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get unconfirmed transactions (asynchronously)
     * Gets the array of transactions not included in a block where an account is the sender or receiver. 
     * @param accountId Account public key or address. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call unconfirmedTransactionsAsync(String accountId, Integer pageSize, String id, String ordering, final ApiCallback<List<TransactionInfoDTO>> _callback) throws ApiException {

        okhttp3.Call localVarCall = unconfirmedTransactionsValidateBeforeCall(accountId, pageSize, id, ordering, _callback);
        Type localVarReturnType = new TypeToken<List<TransactionInfoDTO>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
