/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

public class BlockDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    @JsonProperty(value="network")
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    @JsonProperty(value="height")
    private BigInteger height = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    @JsonProperty(value="timestamp")
    private BigInteger timestamp = null;
    public static final String JSON_PROPERTY_DIFFICULTY = "difficulty";
    @JsonProperty(value="difficulty")
    private BigInteger difficulty = null;
    public static final String JSON_PROPERTY_PREVIOUS_BLOCK_HASH = "previousBlockHash";
    @JsonProperty(value="previousBlockHash")
    private String previousBlockHash;
    public static final String JSON_PROPERTY_TRANSACTIONS_HASH = "transactionsHash";
    @JsonProperty(value="transactionsHash")
    private String transactionsHash;
    public static final String JSON_PROPERTY_RECEIPTS_HASH = "receiptsHash";
    @JsonProperty(value="receiptsHash")
    private String receiptsHash;
    public static final String JSON_PROPERTY_STATE_HASH = "stateHash";
    @JsonProperty(value="stateHash")
    private String stateHash;
    public static final String JSON_PROPERTY_BENEFICIARY_PUBLIC_KEY = "beneficiaryPublicKey";
    @JsonProperty(value="beneficiaryPublicKey")
    private String beneficiaryPublicKey;
    public static final String JSON_PROPERTY_FEE_MULTIPLIER = "feeMultiplier";
    @JsonProperty(value="feeMultiplier")
    private Integer feeMultiplier;

    public BlockDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public BlockDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public BlockDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BlockDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public BlockDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BlockDTO height(BigInteger height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    public BigInteger getHeight() {
        return this.height;
    }

    public void setHeight(BigInteger height) {
        this.height = height;
    }

    public BlockDTO timestamp(BigInteger timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="108303181802", required=true, value="Number of seconds elapsed since the creation of the nemesis block.")
    public BigInteger getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(BigInteger timestamp) {
        this.timestamp = timestamp;
    }

    public BlockDTO difficulty(BigInteger difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    @ApiModelProperty(example="100000000000000", required=true, value="Defines how difficult it will be to harvest next the block, based on previous blocks.")
    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(BigInteger difficulty) {
        this.difficulty = difficulty;
    }

    public BlockDTO previousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public BlockDTO transactionsHash(String transactionsHash) {
        this.transactionsHash = transactionsHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    public String getTransactionsHash() {
        return this.transactionsHash;
    }

    public void setTransactionsHash(String transactionsHash) {
        this.transactionsHash = transactionsHash;
    }

    public BlockDTO receiptsHash(String receiptsHash) {
        this.receiptsHash = receiptsHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    public String getReceiptsHash() {
        return this.receiptsHash;
    }

    public void setReceiptsHash(String receiptsHash) {
        this.receiptsHash = receiptsHash;
    }

    public BlockDTO stateHash(String stateHash) {
        this.stateHash = stateHash;
        return this;
    }

    @ApiModelProperty(example="C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required=true, value="")
    public String getStateHash() {
        return this.stateHash;
    }

    public void setStateHash(String stateHash) {
        this.stateHash = stateHash;
    }

    public BlockDTO beneficiaryPublicKey(String beneficiaryPublicKey) {
        this.beneficiaryPublicKey = beneficiaryPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getBeneficiaryPublicKey() {
        return this.beneficiaryPublicKey;
    }

    public void setBeneficiaryPublicKey(String beneficiaryPublicKey) {
        this.beneficiaryPublicKey = beneficiaryPublicKey;
    }

    public BlockDTO feeMultiplier(Integer feeMultiplier) {
        this.feeMultiplier = feeMultiplier;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Fee multiplier applied to transactions contained in block.")
    public Integer getFeeMultiplier() {
        return this.feeMultiplier;
    }

    public void setFeeMultiplier(Integer feeMultiplier) {
        this.feeMultiplier = feeMultiplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockDTO blockDTO = (BlockDTO)o;
        return Objects.equals(this.signature, blockDTO.signature) && Objects.equals(this.signerPublicKey, blockDTO.signerPublicKey) && Objects.equals(this.version, blockDTO.version) && Objects.equals((Object)this.network, (Object)blockDTO.network) && Objects.equals(this.type, blockDTO.type) && Objects.equals(this.height, blockDTO.height) && Objects.equals(this.timestamp, blockDTO.timestamp) && Objects.equals(this.difficulty, blockDTO.difficulty) && Objects.equals(this.previousBlockHash, blockDTO.previousBlockHash) && Objects.equals(this.transactionsHash, blockDTO.transactionsHash) && Objects.equals(this.receiptsHash, blockDTO.receiptsHash) && Objects.equals(this.stateHash, blockDTO.stateHash) && Objects.equals(this.beneficiaryPublicKey, blockDTO.beneficiaryPublicKey) && Objects.equals(this.feeMultiplier, blockDTO.feeMultiplier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.height, this.timestamp, this.difficulty, this.previousBlockHash, this.transactionsHash, this.receiptsHash, this.stateHash, this.beneficiaryPublicKey, this.feeMultiplier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    difficulty: ").append(this.toIndentedString(this.difficulty)).append("\n");
        sb.append("    previousBlockHash: ").append(this.toIndentedString(this.previousBlockHash)).append("\n");
        sb.append("    transactionsHash: ").append(this.toIndentedString(this.transactionsHash)).append("\n");
        sb.append("    receiptsHash: ").append(this.toIndentedString(this.receiptsHash)).append("\n");
        sb.append("    stateHash: ").append(this.toIndentedString(this.stateHash)).append("\n");
        sb.append("    beneficiaryPublicKey: ").append(this.toIndentedString(this.beneficiaryPublicKey)).append("\n");
        sb.append("    feeMultiplier: ").append(this.toIndentedString(this.feeMultiplier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

