/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;
import io.nem.sdk.openapi.jersey2.model.AnnounceTransactionInfoDTO;
import io.nem.sdk.openapi.jersey2.model.Cosignature;
import io.nem.sdk.openapi.jersey2.model.TransactionHashes;
import io.nem.sdk.openapi.jersey2.model.TransactionIds;
import io.nem.sdk.openapi.jersey2.model.TransactionInfoDTO;
import io.nem.sdk.openapi.jersey2.model.TransactionPayload;
import io.nem.sdk.openapi.jersey2.model.TransactionStatusDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class TransactionRoutesApi {
    private ApiClient apiClient;

    public TransactionRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AnnounceTransactionInfoDTO announceCosignatureTransaction(Cosignature cosignature) throws ApiException {
        return this.announceCosignatureTransactionWithHttpInfo(cosignature).getData();
    }

    public ApiResponse<AnnounceTransactionInfoDTO> announceCosignatureTransactionWithHttpInfo(Cosignature cosignature) throws ApiException {
        Cosignature localVarPostBody = cosignature;
        if (cosignature == null) {
            throw new ApiException(400, "Missing the required parameter 'cosignature' when calling announceCosignatureTransaction");
        }
        String localVarPath = "/transaction/cosignature";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AnnounceTransactionInfoDTO announcePartialTransaction(TransactionPayload transactionPayload) throws ApiException {
        return this.announcePartialTransactionWithHttpInfo(transactionPayload).getData();
    }

    public ApiResponse<AnnounceTransactionInfoDTO> announcePartialTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
        TransactionPayload localVarPostBody = transactionPayload;
        if (transactionPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionPayload' when calling announcePartialTransaction");
        }
        String localVarPath = "/transaction/partial";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AnnounceTransactionInfoDTO announceTransaction(TransactionPayload transactionPayload) throws ApiException {
        return this.announceTransactionWithHttpInfo(transactionPayload).getData();
    }

    public ApiResponse<AnnounceTransactionInfoDTO> announceTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
        TransactionPayload localVarPostBody = transactionPayload;
        if (transactionPayload == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionPayload' when calling announceTransaction");
        }
        String localVarPath = "/transaction";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TransactionInfoDTO getTransaction(String transactionId) throws ApiException {
        return this.getTransactionWithHttpInfo(transactionId).getData();
    }

    public ApiResponse<TransactionInfoDTO> getTransactionWithHttpInfo(String transactionId) throws ApiException {
        Object localVarPostBody = new Object();
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getTransaction");
        }
        String localVarPath = "/transaction/{transactionId}".replaceAll("\\{transactionId\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TransactionInfoDTO> localVarReturnType = new GenericType<TransactionInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public TransactionStatusDTO getTransactionStatus(String hash) throws ApiException {
        return this.getTransactionStatusWithHttpInfo(hash).getData();
    }

    public ApiResponse<TransactionStatusDTO> getTransactionStatusWithHttpInfo(String hash) throws ApiException {
        Object localVarPostBody = new Object();
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getTransactionStatus");
        }
        String localVarPath = "/transaction/{hash}/status".replaceAll("\\{hash\\}", this.apiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<TransactionStatusDTO> localVarReturnType = new GenericType<TransactionStatusDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TransactionInfoDTO> getTransactions(TransactionIds transactionIds) throws ApiException {
        return this.getTransactionsWithHttpInfo(transactionIds).getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getTransactionsWithHttpInfo(TransactionIds transactionIds) throws ApiException {
        TransactionIds localVarPostBody = transactionIds;
        if (transactionIds == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionIds' when calling getTransactions");
        }
        String localVarPath = "/transaction";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TransactionStatusDTO> getTransactionsStatuses(TransactionHashes transactionHashes) throws ApiException {
        return this.getTransactionsStatusesWithHttpInfo(transactionHashes).getData();
    }

    public ApiResponse<List<TransactionStatusDTO>> getTransactionsStatusesWithHttpInfo(TransactionHashes transactionHashes) throws ApiException {
        TransactionHashes localVarPostBody = transactionHashes;
        if (transactionHashes == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionHashes' when calling getTransactionsStatuses");
        }
        String localVarPath = "/transaction/statuses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionStatusDTO>> localVarReturnType = new GenericType<List<TransactionStatusDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

