/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;
import io.nem.sdk.openapi.jersey2.model.AccountIds;
import io.nem.sdk.openapi.jersey2.model.AccountInfoDTO;
import io.nem.sdk.openapi.jersey2.model.TransactionInfoDTO;
import io.nem.sdk.openapi.jersey2.model.TransactionTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AccountRoutesApi {
    private ApiClient apiClient;

    public AccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<TransactionInfoDTO> getAccountConfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        return this.getAccountConfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type).getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountConfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountConfirmedTransactions");
        }
        String localVarPath = "/account/{accountId}/transactions".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", (Object)type));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TransactionInfoDTO> getAccountIncomingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        return this.getAccountIncomingTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type).getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountIncomingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountIncomingTransactions");
        }
        String localVarPath = "/account/{accountId}/transactions/incoming".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", (Object)type));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AccountInfoDTO getAccountInfo(String accountId) throws ApiException {
        return this.getAccountInfoWithHttpInfo(accountId).getData();
    }

    public ApiResponse<AccountInfoDTO> getAccountInfoWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountInfo");
        }
        String localVarPath = "/account/{accountId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountInfoDTO> localVarReturnType = new GenericType<AccountInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TransactionInfoDTO> getAccountOutgoingTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        return this.getAccountOutgoingTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type).getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountOutgoingTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountOutgoingTransactions");
        }
        String localVarPath = "/account/{accountId}/transactions/outgoing".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", (Object)type));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TransactionInfoDTO> getAccountPartialTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        return this.getAccountPartialTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type).getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountPartialTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountPartialTransactions");
        }
        String localVarPath = "/account/{accountId}/transactions/partial".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", (Object)type));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TransactionInfoDTO> getAccountUnconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        return this.getAccountUnconfirmedTransactionsWithHttpInfo(accountId, pageSize, id, ordering, type).getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getAccountUnconfirmedTransactionsWithHttpInfo(String accountId, Integer pageSize, String id, String ordering, TransactionTypeEnum type) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountUnconfirmedTransactions");
        }
        String localVarPath = "/account/{accountId}/transactions/unconfirmed".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", (Object)type));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AccountInfoDTO> getAccountsInfo(AccountIds accountIds) throws ApiException {
        return this.getAccountsInfoWithHttpInfo(accountIds).getData();
    }

    public ApiResponse<List<AccountInfoDTO>> getAccountsInfoWithHttpInfo(AccountIds accountIds) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<AccountInfoDTO>> localVarReturnType = new GenericType<List<AccountInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

