package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.sdk.openapi.jersey2.model.MetadataDTO;
import io.nem.sdk.openapi.jersey2.model.MetadataEntriesDTO;
import io.nem.sdk.openapi.jersey2.model.ModelError;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-02T21:53:44.206008392-03:00[America/Argentina/Buenos_Aires]")
public class MetadataRoutesApi {
  private ApiClient apiClient;

  public MetadataRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MetadataRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get account metadata
   * Returns the account metadata given an account id.
   * @param accountId Account public key or address. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Metadata identifier up to which metadata are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getAccountMetadata(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
    return getAccountMetadataWithHttpInfo(accountId, pageSize, id, ordering).getData();
      }

  /**
   * Get account metadata
   * Returns the account metadata given an account id.
   * @param accountId Account public key or address. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Metadata identifier up to which metadata are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getAccountMetadataWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/account/{accountId}"
      .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get account metadata
   * Returns the account metadata given an account id and a key.
   * @param accountId Account public key or address. (required)
   * @param key Metadata key. (required)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getAccountMetadataByKey(String accountId, String key) throws ApiException {
    return getAccountMetadataByKeyWithHttpInfo(accountId, key).getData();
      }

  /**
   * Get account metadata
   * Returns the account metadata given an account id and a key.
   * @param accountId Account public key or address. (required)
   * @param key Metadata key. (required)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getAccountMetadataByKeyWithHttpInfo(String accountId, String key) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountMetadataByKey");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getAccountMetadataByKey");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/account/{accountId}/key/{key}"
      .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get account metadata
   * Returns the account metadata given an account id, a key, and a sender.
   * @param accountId Account public key or address. (required)
   * @param key Metadata key. (required)
   * @param publicKey Account public key. (required)
   * @return MetadataDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataDTO getAccountMetadataByKeyAndSender(String accountId, String key, String publicKey) throws ApiException {
    return getAccountMetadataByKeyAndSenderWithHttpInfo(accountId, key, publicKey).getData();
      }

  /**
   * Get account metadata
   * Returns the account metadata given an account id, a key, and a sender.
   * @param accountId Account public key or address. (required)
   * @param key Metadata key. (required)
   * @param publicKey Account public key. (required)
   * @return ApiResponse&lt;MetadataDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataDTO> getAccountMetadataByKeyAndSenderWithHttpInfo(String accountId, String key, String publicKey) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'publicKey' is set
    if (publicKey == null) {
      throw new ApiException(400, "Missing the required parameter 'publicKey' when calling getAccountMetadataByKeyAndSender");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/account/{accountId}/key/{key}/sender/{publicKey}"
      .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "publicKey" + "\\}", apiClient.escapeString(publicKey.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id.
   * @param mosaicId Mosaic identifier. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Metadata identifier up to which metadata are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
    return getMosaicMetadataWithHttpInfo(mosaicId, pageSize, id, ordering).getData();
      }

  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id.
   * @param mosaicId Mosaic identifier. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Metadata identifier up to which metadata are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getMosaicMetadataWithHttpInfo(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/mosaic/{mosaicId}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id and a key.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getMosaicMetadataByKey(String mosaicId, String key) throws ApiException {
    return getMosaicMetadataByKeyWithHttpInfo(mosaicId, key).getData();
      }

  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id and a key.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getMosaicMetadataByKeyWithHttpInfo(String mosaicId, String key) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKey");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id, a key, and a sender.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @param publicKey Account public key. (required)
   * @return MetadataDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataDTO getMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey) throws ApiException {
    return getMosaicMetadataByKeyAndSenderWithHttpInfo(mosaicId, key, publicKey).getData();
      }

  /**
   * Get mosaic metadata
   * Returns the mosaic metadata given a mosaic id, a key, and a sender.
   * @param mosaicId Mosaic identifier. (required)
   * @param key Metadata key. (required)
   * @param publicKey Account public key. (required)
   * @return ApiResponse&lt;MetadataDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataDTO> getMosaicMetadataByKeyAndSenderWithHttpInfo(String mosaicId, String key, String publicKey) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'publicKey' is set
    if (publicKey == null) {
      throw new ApiException(400, "Missing the required parameter 'publicKey' when calling getMosaicMetadataByKeyAndSender");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{publicKey}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "publicKey" + "\\}", apiClient.escapeString(publicKey.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id.
   * @param namespaceId Namespace identifier. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Metadata identifier up to which metadata are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
    return getNamespaceMetadataWithHttpInfo(namespaceId, pageSize, id, ordering).getData();
      }

  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id.
   * @param namespaceId Namespace identifier. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Metadata identifier up to which metadata are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataWithHttpInfo(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/namespace/{namespaceId}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id and a key.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @return MetadataEntriesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataEntriesDTO getNamespaceMetadataByKey(String namespaceId, String key) throws ApiException {
    return getNamespaceMetadataByKeyWithHttpInfo(namespaceId, key).getData();
      }

  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id and a key.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @return ApiResponse&lt;MetadataEntriesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataByKeyWithHttpInfo(String namespaceId, String key) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKey");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id, a key, and a sender.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @param publicKey Account public key. (required)
   * @return MetadataDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MetadataDTO getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey) throws ApiException {
    return getNamespaceMetadataByKeyAndSenderWithHttpInfo(namespaceId, key, publicKey).getData();
      }

  /**
   * Get namespace metadata
   * Returns the namespace metadata given a namespace id, a key, and a sender.
   * @param namespaceId Namespace identifier. (required)
   * @param key Metadata key. (required)
   * @param publicKey Account public key. (required)
   * @return ApiResponse&lt;MetadataDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MetadataDTO> getNamespaceMetadataByKeyAndSenderWithHttpInfo(String namespaceId, String key, String publicKey) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'namespaceId' is set
    if (namespaceId == null) {
      throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'key' is set
    if (key == null) {
      throw new ApiException(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender");
    }
    
    // verify the required parameter 'publicKey' is set
    if (publicKey == null) {
      throw new ApiException(400, "Missing the required parameter 'publicKey' when calling getNamespaceMetadataByKeyAndSender");
    }
    
    // create path and map variables
    String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{publicKey}"
      .replaceAll("\\{" + "namespaceId" + "\\}", apiClient.escapeString(namespaceId.toString()))
      .replaceAll("\\{" + "key" + "\\}", apiClient.escapeString(key.toString()))
      .replaceAll("\\{" + "publicKey" + "\\}", apiClient.escapeString(publicKey.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
