/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to create or modify a multisig account.")
public class AccountMetadataTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    @JsonProperty(value="network")
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_TARGET_PUBLIC_KEY = "targetPublicKey";
    @JsonProperty(value="targetPublicKey")
    private String targetPublicKey;
    public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
    @JsonProperty(value="scopedMetadataKey")
    private String scopedMetadataKey;
    public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
    @JsonProperty(value="valueSizeDelta")
    private Integer valueSizeDelta;
    public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
    @JsonProperty(value="valueSize")
    private Integer valueSize;
    public static final String JSON_PROPERTY_VALUE = "value";
    @JsonProperty(value="value")
    private String value;

    public AccountMetadataTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AccountMetadataTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public AccountMetadataTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AccountMetadataTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public AccountMetadataTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AccountMetadataTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public AccountMetadataTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public AccountMetadataTransactionDTO targetPublicKey(String targetPublicKey) {
        this.targetPublicKey = targetPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getTargetPublicKey() {
        return this.targetPublicKey;
    }

    public void setTargetPublicKey(String targetPublicKey) {
        this.targetPublicKey = targetPublicKey;
    }

    public AccountMetadataTransactionDTO scopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Metadata key scoped to source, target and type.")
    public String getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public void setScopedMetadataKey(String scopedMetadataKey) {
        this.scopedMetadataKey = scopedMetadataKey;
    }

    public AccountMetadataTransactionDTO valueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
        return this;
    }

    @ApiModelProperty(required=true, value="Change in value size in bytes.")
    public Integer getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public void setValueSizeDelta(Integer valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
    }

    public AccountMetadataTransactionDTO valueSize(Integer valueSize) {
        this.valueSize = valueSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Value size in bytes.")
    public Integer getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(Integer valueSize) {
        this.valueSize = valueSize;
    }

    public AccountMetadataTransactionDTO value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="When there is an existing value, the new value is calculated as xor(previous-value, value).")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountMetadataTransactionDTO accountMetadataTransactionDTO = (AccountMetadataTransactionDTO)o;
        return Objects.equals(this.signature, accountMetadataTransactionDTO.signature) && Objects.equals(this.signerPublicKey, accountMetadataTransactionDTO.signerPublicKey) && Objects.equals(this.version, accountMetadataTransactionDTO.version) && Objects.equals((Object)this.network, (Object)accountMetadataTransactionDTO.network) && Objects.equals(this.type, accountMetadataTransactionDTO.type) && Objects.equals(this.maxFee, accountMetadataTransactionDTO.maxFee) && Objects.equals(this.deadline, accountMetadataTransactionDTO.deadline) && Objects.equals(this.targetPublicKey, accountMetadataTransactionDTO.targetPublicKey) && Objects.equals(this.scopedMetadataKey, accountMetadataTransactionDTO.scopedMetadataKey) && Objects.equals(this.valueSizeDelta, accountMetadataTransactionDTO.valueSizeDelta) && Objects.equals(this.valueSize, accountMetadataTransactionDTO.valueSize) && Objects.equals(this.value, accountMetadataTransactionDTO.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.targetPublicKey, this.scopedMetadataKey, this.valueSizeDelta, this.valueSize, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountMetadataTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    targetPublicKey: ").append(this.toIndentedString(this.targetPublicKey)).append("\n");
        sb.append("    scopedMetadataKey: ").append(this.toIndentedString(this.scopedMetadataKey)).append("\n");
        sb.append("    valueSizeDelta: ").append(this.toIndentedString(this.valueSizeDelta)).append("\n");
        sb.append("    valueSize: ").append(this.toIndentedString(this.valueSize)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

