package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.sdk.openapi.jersey2.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.jersey2.model.ModelError;
import io.nem.sdk.openapi.jersey2.model.StatementsDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-12-31T15:15:14.211661537-03:00[America/Argentina/Buenos_Aires]")
public class ReceiptRoutesApi {
  private ApiClient apiClient;

  public ReceiptRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ReceiptRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get receipts from a block
   * Returns the receipts linked to a block.
   * @param height Block height.  (required)
   * @return StatementsDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public StatementsDTO getBlockReceipts(java.math.BigInteger height) throws ApiException {
    return getBlockReceiptsWithHttpInfo(height).getData();
      }

  /**
   * Get receipts from a block
   * Returns the receipts linked to a block.
   * @param height Block height.  (required)
   * @return ApiResponse&lt;StatementsDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<StatementsDTO> getBlockReceiptsWithHttpInfo(java.math.BigInteger height) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockReceipts");
    }
    
    // create path and map variables
    String localVarPath = "/block/{height}/receipts"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<StatementsDTO> localVarReturnType = new GenericType<StatementsDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the merkle path for a given a receipt statement hash and block
   * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
   * @param height Block height.  (required)
   * @param hash Receipt hash. (required)
   * @return MerkleProofInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MerkleProofInfoDTO getMerkleReceipts(java.math.BigInteger height, String hash) throws ApiException {
    return getMerkleReceiptsWithHttpInfo(height, hash).getData();
      }

  /**
   * Get the merkle path for a given a receipt statement hash and block
   * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
   * @param height Block height.  (required)
   * @param hash Receipt hash. (required)
   * @return ApiResponse&lt;MerkleProofInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(java.math.BigInteger height, String hash) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleReceipts");
    }
    
    // verify the required parameter 'hash' is set
    if (hash == null) {
      throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleReceipts");
    }
    
    // create path and map variables
    String localVarPath = "/block/{height}/receipt/{hash}/merkle"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()))
      .replaceAll("\\{" + "hash" + "\\}", apiClient.escapeString(hash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
