/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.NamespaceRegistrationTypeEnum;
import io.nem.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to create or renew a namespace.")
public class NamespaceRegistrationTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    @JsonProperty(value="network")
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_DURATION = "duration";
    @JsonProperty(value="duration")
    private BigInteger duration = null;
    public static final String JSON_PROPERTY_PARENT_ID = "parentId";
    @JsonProperty(value="parentId")
    private String parentId;
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private String id;
    public static final String JSON_PROPERTY_REGISTRATION_TYPE = "registrationType";
    @JsonProperty(value="registrationType")
    private NamespaceRegistrationTypeEnum registrationType;
    public static final String JSON_PROPERTY_NAME = "name";
    @JsonProperty(value="name")
    private String name;

    public NamespaceRegistrationTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public NamespaceRegistrationTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public NamespaceRegistrationTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public NamespaceRegistrationTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public NamespaceRegistrationTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public NamespaceRegistrationTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public NamespaceRegistrationTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public NamespaceRegistrationTransactionDTO duration(BigInteger duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDuration() {
        return this.duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public NamespaceRegistrationTransactionDTO parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Namespace identifier.")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public NamespaceRegistrationTransactionDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Namespace identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NamespaceRegistrationTransactionDTO registrationType(NamespaceRegistrationTypeEnum registrationType) {
        this.registrationType = registrationType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NamespaceRegistrationTypeEnum getRegistrationType() {
        return this.registrationType;
    }

    public void setRegistrationType(NamespaceRegistrationTypeEnum registrationType) {
        this.registrationType = registrationType;
    }

    public NamespaceRegistrationTransactionDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Namespace name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceRegistrationTransactionDTO namespaceRegistrationTransactionDTO = (NamespaceRegistrationTransactionDTO)o;
        return Objects.equals(this.signature, namespaceRegistrationTransactionDTO.signature) && Objects.equals(this.signerPublicKey, namespaceRegistrationTransactionDTO.signerPublicKey) && Objects.equals(this.version, namespaceRegistrationTransactionDTO.version) && Objects.equals((Object)this.network, (Object)namespaceRegistrationTransactionDTO.network) && Objects.equals(this.type, namespaceRegistrationTransactionDTO.type) && Objects.equals(this.maxFee, namespaceRegistrationTransactionDTO.maxFee) && Objects.equals(this.deadline, namespaceRegistrationTransactionDTO.deadline) && Objects.equals(this.duration, namespaceRegistrationTransactionDTO.duration) && Objects.equals(this.parentId, namespaceRegistrationTransactionDTO.parentId) && Objects.equals(this.id, namespaceRegistrationTransactionDTO.id) && Objects.equals((Object)this.registrationType, (Object)namespaceRegistrationTransactionDTO.registrationType) && Objects.equals(this.name, namespaceRegistrationTransactionDTO.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.duration, this.parentId, this.id, this.registrationType, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NamespaceRegistrationTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    registrationType: ").append(this.toIndentedString((Object)this.registrationType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

