/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.MosaicSupplyChangeActionEnum;
import io.nem.sdk.openapi.jersey2.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Transaction to increase or decrease the supply of a mosaic.")
public class MosaicSupplyChangeTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    @JsonProperty(value="network")
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    @JsonProperty(value="mosaicId")
    private String mosaicId;
    public static final String JSON_PROPERTY_DELTA = "delta";
    @JsonProperty(value="delta")
    private BigInteger delta = null;
    public static final String JSON_PROPERTY_ACTION = "action";
    @JsonProperty(value="action")
    private MosaicSupplyChangeActionEnum action;

    public MosaicSupplyChangeTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public MosaicSupplyChangeTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public MosaicSupplyChangeTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MosaicSupplyChangeTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public MosaicSupplyChangeTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public MosaicSupplyChangeTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public MosaicSupplyChangeTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public MosaicSupplyChangeTransactionDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="85BBEA6CC462B244", required=true, value="Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public MosaicSupplyChangeTransactionDTO delta(BigInteger delta) {
        this.delta = delta;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getDelta() {
        return this.delta;
    }

    public void setDelta(BigInteger delta) {
        this.delta = delta;
    }

    public MosaicSupplyChangeTransactionDTO action(MosaicSupplyChangeActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MosaicSupplyChangeActionEnum getAction() {
        return this.action;
    }

    public void setAction(MosaicSupplyChangeActionEnum action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicSupplyChangeTransactionDTO mosaicSupplyChangeTransactionDTO = (MosaicSupplyChangeTransactionDTO)o;
        return Objects.equals(this.signature, mosaicSupplyChangeTransactionDTO.signature) && Objects.equals(this.signerPublicKey, mosaicSupplyChangeTransactionDTO.signerPublicKey) && Objects.equals(this.version, mosaicSupplyChangeTransactionDTO.version) && Objects.equals((Object)this.network, (Object)mosaicSupplyChangeTransactionDTO.network) && Objects.equals(this.type, mosaicSupplyChangeTransactionDTO.type) && Objects.equals(this.maxFee, mosaicSupplyChangeTransactionDTO.maxFee) && Objects.equals(this.deadline, mosaicSupplyChangeTransactionDTO.deadline) && Objects.equals(this.mosaicId, mosaicSupplyChangeTransactionDTO.mosaicId) && Objects.equals(this.delta, mosaicSupplyChangeTransactionDTO.delta) && Objects.equals((Object)this.action, (Object)mosaicSupplyChangeTransactionDTO.action);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.mosaicId, this.delta, this.action});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicSupplyChangeTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    delta: ").append(this.toIndentedString(this.delta)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

