/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;
import io.nem.sdk.openapi.jersey2.model.AccountIds;
import io.nem.sdk.openapi.jersey2.model.AccountRestrictionsInfoDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class RestrictionAccountRoutesApi {
    private ApiClient apiClient;

    public RestrictionAccountRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RestrictionAccountRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AccountRestrictionsInfoDTO getAccountRestrictions(String accountId) throws ApiException {
        return this.getAccountRestrictionsWithHttpInfo(accountId).getData();
    }

    public ApiResponse<AccountRestrictionsInfoDTO> getAccountRestrictionsWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountRestrictions");
        }
        String localVarPath = "/restrictions/account/{accountId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AccountRestrictionsInfoDTO> localVarReturnType = new GenericType<AccountRestrictionsInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AccountRestrictionsInfoDTO> getAccountRestrictionsFromAccounts(AccountIds accountIds) throws ApiException {
        return this.getAccountRestrictionsFromAccountsWithHttpInfo(accountIds).getData();
    }

    public ApiResponse<List<AccountRestrictionsInfoDTO>> getAccountRestrictionsFromAccountsWithHttpInfo(AccountIds accountIds) throws ApiException {
        AccountIds localVarPostBody = accountIds;
        String localVarPath = "/restrictions/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<AccountRestrictionsInfoDTO>> localVarReturnType = new GenericType<List<AccountRestrictionsInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

