/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;
import io.nem.sdk.openapi.jersey2.model.MetadataDTO;
import io.nem.sdk.openapi.jersey2.model.MetadataEntriesDTO;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class MetadataRoutesApi {
    private ApiClient apiClient;

    public MetadataRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetadataRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MetadataEntriesDTO getAccountMetadata(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        return this.getAccountMetadataWithHttpInfo(accountId, pageSize, id, ordering).getData();
    }

    public ApiResponse<MetadataEntriesDTO> getAccountMetadataWithHttpInfo(String accountId, Integer pageSize, String id, String ordering) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountMetadata");
        }
        String localVarPath = "/metadata/account/{accountId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataEntriesDTO getAccountMetadataByKey(String accountId, String key) throws ApiException {
        return this.getAccountMetadataByKeyWithHttpInfo(accountId, key).getData();
    }

    public ApiResponse<MetadataEntriesDTO> getAccountMetadataByKeyWithHttpInfo(String accountId, String key) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountMetadataByKey");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getAccountMetadataByKey");
        }
        String localVarPath = "/metadata/account/{accountId}/key/{key}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataDTO getAccountMetadataByKeyAndSender(String accountId, String key, String publicKey) throws ApiException {
        return this.getAccountMetadataByKeyAndSenderWithHttpInfo(accountId, key, publicKey).getData();
    }

    public ApiResponse<MetadataDTO> getAccountMetadataByKeyAndSenderWithHttpInfo(String accountId, String key, String publicKey) throws ApiException {
        Object localVarPostBody = new Object();
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountMetadataByKeyAndSender");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender");
        }
        if (publicKey == null) {
            throw new ApiException(400, "Missing the required parameter 'publicKey' when calling getAccountMetadataByKeyAndSender");
        }
        String localVarPath = "/metadata/account/{accountId}/key/{key}/sender/{publicKey}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString())).replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataEntriesDTO getMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
        return this.getMosaicMetadataWithHttpInfo(mosaicId, pageSize, id, ordering).getData();
    }

    public ApiResponse<MetadataEntriesDTO> getMosaicMetadataWithHttpInfo(String mosaicId, Integer pageSize, String id, String ordering) throws ApiException {
        Object localVarPostBody = new Object();
        if (mosaicId == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadata");
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}".replaceAll("\\{mosaicId\\}", this.apiClient.escapeString(mosaicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataEntriesDTO getMosaicMetadataByKey(String mosaicId, String key) throws ApiException {
        return this.getMosaicMetadataByKeyWithHttpInfo(mosaicId, key).getData();
    }

    public ApiResponse<MetadataEntriesDTO> getMosaicMetadataByKeyWithHttpInfo(String mosaicId, String key) throws ApiException {
        Object localVarPostBody = new Object();
        if (mosaicId == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKey");
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}".replaceAll("\\{mosaicId\\}", this.apiClient.escapeString(mosaicId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataDTO getMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey) throws ApiException {
        return this.getMosaicMetadataByKeyAndSenderWithHttpInfo(mosaicId, key, publicKey).getData();
    }

    public ApiResponse<MetadataDTO> getMosaicMetadataByKeyAndSenderWithHttpInfo(String mosaicId, String key, String publicKey) throws ApiException {
        Object localVarPostBody = new Object();
        if (mosaicId == null) {
            throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender");
        }
        if (publicKey == null) {
            throw new ApiException(400, "Missing the required parameter 'publicKey' when calling getMosaicMetadataByKeyAndSender");
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{publicKey}".replaceAll("\\{mosaicId\\}", this.apiClient.escapeString(mosaicId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString())).replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataEntriesDTO getNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
        return this.getNamespaceMetadataWithHttpInfo(namespaceId, pageSize, id, ordering).getData();
    }

    public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataWithHttpInfo(String namespaceId, Integer pageSize, String id, String ordering) throws ApiException {
        Object localVarPostBody = new Object();
        if (namespaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadata");
        }
        String localVarPath = "/metadata/namespace/{namespaceId}".replaceAll("\\{namespaceId\\}", this.apiClient.escapeString(namespaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataEntriesDTO getNamespaceMetadataByKey(String namespaceId, String key) throws ApiException {
        return this.getNamespaceMetadataByKeyWithHttpInfo(namespaceId, key).getData();
    }

    public ApiResponse<MetadataEntriesDTO> getNamespaceMetadataByKeyWithHttpInfo(String namespaceId, String key) throws ApiException {
        Object localVarPostBody = new Object();
        if (namespaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKey");
        }
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}".replaceAll("\\{namespaceId\\}", this.apiClient.escapeString(namespaceId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataEntriesDTO> localVarReturnType = new GenericType<MetadataEntriesDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MetadataDTO getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey) throws ApiException {
        return this.getNamespaceMetadataByKeyAndSenderWithHttpInfo(namespaceId, key, publicKey).getData();
    }

    public ApiResponse<MetadataDTO> getNamespaceMetadataByKeyAndSenderWithHttpInfo(String namespaceId, String key, String publicKey) throws ApiException {
        Object localVarPostBody = new Object();
        if (namespaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender");
        }
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender");
        }
        if (publicKey == null) {
            throw new ApiException(400, "Missing the required parameter 'publicKey' when calling getNamespaceMetadataByKeyAndSender");
        }
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{publicKey}".replaceAll("\\{namespaceId\\}", this.apiClient.escapeString(namespaceId.toString())).replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString())).replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MetadataDTO> localVarReturnType = new GenericType<MetadataDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

