/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;
import io.nem.sdk.openapi.jersey2.model.BlockInfoDTO;
import io.nem.sdk.openapi.jersey2.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.jersey2.model.TransactionInfoDTO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class BlockRoutesApi {
    private ApiClient apiClient;

    public BlockRoutesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BlockRoutesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BlockInfoDTO getBlockByHeight(BigInteger height) throws ApiException {
        return this.getBlockByHeightWithHttpInfo(height).getData();
    }

    public ApiResponse<BlockInfoDTO> getBlockByHeightWithHttpInfo(BigInteger height) throws ApiException {
        Object localVarPostBody = new Object();
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockByHeight");
        }
        String localVarPath = "/block/{height}".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BlockInfoDTO> localVarReturnType = new GenericType<BlockInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<TransactionInfoDTO> getBlockTransactions(BigInteger height, Integer pageSize, String id, String ordering) throws ApiException {
        return this.getBlockTransactionsWithHttpInfo(height, pageSize, id, ordering).getData();
    }

    public ApiResponse<List<TransactionInfoDTO>> getBlockTransactionsWithHttpInfo(BigInteger height, Integer pageSize, String id, String ordering) throws ApiException {
        Object localVarPostBody = new Object();
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockTransactions");
        }
        String localVarPath = "/block/{height}/transactions".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<BlockInfoDTO> getBlocksByHeightWithLimit(BigInteger height, Integer limit) throws ApiException {
        return this.getBlocksByHeightWithLimitWithHttpInfo(height, limit).getData();
    }

    public ApiResponse<List<BlockInfoDTO>> getBlocksByHeightWithLimitWithHttpInfo(BigInteger height, Integer limit) throws ApiException {
        Object localVarPostBody = new Object();
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getBlocksByHeightWithLimit");
        }
        if (limit == null) {
            throw new ApiException(400, "Missing the required parameter 'limit' when calling getBlocksByHeightWithLimit");
        }
        String localVarPath = "/blocks/{height}/limit/{limit}".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString())).replaceAll("\\{limit\\}", this.apiClient.escapeString(limit.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<BlockInfoDTO>> localVarReturnType = new GenericType<List<BlockInfoDTO>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MerkleProofInfoDTO getMerkleTransaction(BigInteger height, String hash) throws ApiException {
        return this.getMerkleTransactionWithHttpInfo(height, hash).getData();
    }

    public ApiResponse<MerkleProofInfoDTO> getMerkleTransactionWithHttpInfo(BigInteger height, String hash) throws ApiException {
        Object localVarPostBody = new Object();
        if (height == null) {
            throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleTransaction");
        }
        if (hash == null) {
            throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleTransaction");
        }
        String localVarPath = "/block/{height}/transaction/{hash}/merkle".replaceAll("\\{height\\}", this.apiClient.escapeString(height.toString())).replaceAll("\\{hash\\}", this.apiClient.escapeString(hash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

