package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.sdk.openapi.jersey2.model.AnnounceTransactionInfoDTO;
import io.nem.sdk.openapi.jersey2.model.Cosignature;
import io.nem.sdk.openapi.jersey2.model.ModelError;
import io.nem.sdk.openapi.jersey2.model.TransactionHashes;
import io.nem.sdk.openapi.jersey2.model.TransactionIds;
import io.nem.sdk.openapi.jersey2.model.TransactionInfoDTO;
import io.nem.sdk.openapi.jersey2.model.TransactionPayload;
import io.nem.sdk.openapi.jersey2.model.TransactionStatusDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-01T18:24:11.461968915-03:00[America/Argentina/Buenos_Aires]")
public class TransactionRoutesApi {
  private ApiClient apiClient;

  public TransactionRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TransactionRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Announce a cosignature transaction
   * Announces a cosignature transaction to the network.
   * @param cosignature  (required)
   * @return AnnounceTransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AnnounceTransactionInfoDTO announceCosignatureTransaction(Cosignature cosignature) throws ApiException {
    return announceCosignatureTransactionWithHttpInfo(cosignature).getData();
      }

  /**
   * Announce a cosignature transaction
   * Announces a cosignature transaction to the network.
   * @param cosignature  (required)
   * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AnnounceTransactionInfoDTO> announceCosignatureTransactionWithHttpInfo(Cosignature cosignature) throws ApiException {
    Object localVarPostBody = cosignature;
    
    // verify the required parameter 'cosignature' is set
    if (cosignature == null) {
      throw new ApiException(400, "Missing the required parameter 'cosignature' when calling announceCosignatureTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transaction/cosignature";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Announce an aggregate bonded transaction
   * Announces an aggregate bonded transaction to the network.
   * @param transactionPayload  (required)
   * @return AnnounceTransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AnnounceTransactionInfoDTO announcePartialTransaction(TransactionPayload transactionPayload) throws ApiException {
    return announcePartialTransactionWithHttpInfo(transactionPayload).getData();
      }

  /**
   * Announce an aggregate bonded transaction
   * Announces an aggregate bonded transaction to the network.
   * @param transactionPayload  (required)
   * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AnnounceTransactionInfoDTO> announcePartialTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
    Object localVarPostBody = transactionPayload;
    
    // verify the required parameter 'transactionPayload' is set
    if (transactionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionPayload' when calling announcePartialTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transaction/partial";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Announce a new transaction
   * Announces a transaction to the network. We recommended to use the NEM2-SDK to announce transactions as they should be serialized. 
   * @param transactionPayload  (required)
   * @return AnnounceTransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public AnnounceTransactionInfoDTO announceTransaction(TransactionPayload transactionPayload) throws ApiException {
    return announceTransactionWithHttpInfo(transactionPayload).getData();
      }

  /**
   * Announce a new transaction
   * Announces a transaction to the network. We recommended to use the NEM2-SDK to announce transactions as they should be serialized. 
   * @param transactionPayload  (required)
   * @return ApiResponse&lt;AnnounceTransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<AnnounceTransactionInfoDTO> announceTransactionWithHttpInfo(TransactionPayload transactionPayload) throws ApiException {
    Object localVarPostBody = transactionPayload;
    
    // verify the required parameter 'transactionPayload' is set
    if (transactionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionPayload' when calling announceTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transaction";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<AnnounceTransactionInfoDTO> localVarReturnType = new GenericType<AnnounceTransactionInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get transaction information
   * Returns transaction information given a transactionId or hash.
   * @param transactionId Transaction identifier or hash. (required)
   * @return TransactionInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionInfoDTO getTransaction(String transactionId) throws ApiException {
    return getTransactionWithHttpInfo(transactionId).getData();
      }

  /**
   * Get transaction information
   * Returns transaction information given a transactionId or hash.
   * @param transactionId Transaction identifier or hash. (required)
   * @return ApiResponse&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionInfoDTO> getTransactionWithHttpInfo(String transactionId) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'transactionId' is set
    if (transactionId == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/transaction/{transactionId}"
      .replaceAll("\\{" + "transactionId" + "\\}", apiClient.escapeString(transactionId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionInfoDTO> localVarReturnType = new GenericType<TransactionInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get transaction status
   * Returns the transaction status for a given hash.
   * @param hash Transaction hash. (required)
   * @return TransactionStatusDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public TransactionStatusDTO getTransactionStatus(String hash) throws ApiException {
    return getTransactionStatusWithHttpInfo(hash).getData();
      }

  /**
   * Get transaction status
   * Returns the transaction status for a given hash.
   * @param hash Transaction hash. (required)
   * @return ApiResponse&lt;TransactionStatusDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<TransactionStatusDTO> getTransactionStatusWithHttpInfo(String hash) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'hash' is set
    if (hash == null) {
      throw new ApiException(400, "Missing the required parameter 'hash' when calling getTransactionStatus");
    }
    
    // create path and map variables
    String localVarPath = "/transaction/{hash}/status"
      .replaceAll("\\{" + "hash" + "\\}", apiClient.escapeString(hash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<TransactionStatusDTO> localVarReturnType = new GenericType<TransactionStatusDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get transactions information
   * Returns transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return List&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<TransactionInfoDTO> getTransactions(TransactionIds transactionIds) throws ApiException {
    return getTransactionsWithHttpInfo(transactionIds).getData();
      }

  /**
   * Get transactions information
   * Returns transactions information for a given array of transactionIds.
   * @param transactionIds  (required)
   * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<TransactionInfoDTO>> getTransactionsWithHttpInfo(TransactionIds transactionIds) throws ApiException {
    Object localVarPostBody = transactionIds;
    
    // verify the required parameter 'transactionIds' is set
    if (transactionIds == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionIds' when calling getTransactions");
    }
    
    // create path and map variables
    String localVarPath = "/transaction";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get transactions status
   * Returns an array of transaction statuses for a given array of transaction hashes.
   * @param transactionHashes  (required)
   * @return List&lt;TransactionStatusDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<TransactionStatusDTO> getTransactionsStatuses(TransactionHashes transactionHashes) throws ApiException {
    return getTransactionsStatusesWithHttpInfo(transactionHashes).getData();
      }

  /**
   * Get transactions status
   * Returns an array of transaction statuses for a given array of transaction hashes.
   * @param transactionHashes  (required)
   * @return ApiResponse&lt;List&lt;TransactionStatusDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<TransactionStatusDTO>> getTransactionsStatusesWithHttpInfo(TransactionHashes transactionHashes) throws ApiException {
    Object localVarPostBody = transactionHashes;
    
    // verify the required parameter 'transactionHashes' is set
    if (transactionHashes == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionHashes' when calling getTransactionsStatuses");
    }
    
    // create path and map variables
    String localVarPath = "/transaction/statuses";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<TransactionStatusDTO>> localVarReturnType = new GenericType<List<TransactionStatusDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
