/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.CosignatoryModificationDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Transaction to create or modify a multisig account.")
public class MultisigAccountModificationTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_MIN_REMOVAL_DELTA = "minRemovalDelta";
    @JsonProperty(value="minRemovalDelta")
    private Integer minRemovalDelta;
    public static final String JSON_PROPERTY_MIN_APPROVAL_DELTA = "minApprovalDelta";
    @JsonProperty(value="minApprovalDelta")
    private Integer minApprovalDelta;
    public static final String JSON_PROPERTY_MODIFICATIONS = "modifications";
    @JsonProperty(value="modifications")
    private List<CosignatoryModificationDTO> modifications = new ArrayList<CosignatoryModificationDTO>();

    public MultisigAccountModificationTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public MultisigAccountModificationTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public MultisigAccountModificationTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="36867", required=true, value="Entity version. The higher byte represents the network identifier: * 0x68 (MAIN_NET) - Public main network. * 0x98 (TEST_NET) - Public test network. * 0x60 (MIJIN) - Private network. * 0x90 (MIJIN_TEST) - Private test network. ")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MultisigAccountModificationTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public MultisigAccountModificationTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public MultisigAccountModificationTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public MultisigAccountModificationTransactionDTO minRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    public Integer getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public void setMinRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
    }

    public MultisigAccountModificationTransactionDTO minApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    public Integer getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    public void setMinApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
    }

    public MultisigAccountModificationTransactionDTO modifications(List<CosignatoryModificationDTO> modifications) {
        this.modifications = modifications;
        return this;
    }

    public MultisigAccountModificationTransactionDTO addModificationsItem(CosignatoryModificationDTO modificationsItem) {
        this.modifications.add(modificationsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of cosignatory accounts to add or delete.")
    public List<CosignatoryModificationDTO> getModifications() {
        return this.modifications;
    }

    public void setModifications(List<CosignatoryModificationDTO> modifications) {
        this.modifications = modifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigAccountModificationTransactionDTO multisigAccountModificationTransactionDTO = (MultisigAccountModificationTransactionDTO)o;
        return Objects.equals(this.signature, multisigAccountModificationTransactionDTO.signature) && Objects.equals(this.signerPublicKey, multisigAccountModificationTransactionDTO.signerPublicKey) && Objects.equals(this.version, multisigAccountModificationTransactionDTO.version) && Objects.equals(this.type, multisigAccountModificationTransactionDTO.type) && Objects.equals(this.maxFee, multisigAccountModificationTransactionDTO.maxFee) && Objects.equals(this.deadline, multisigAccountModificationTransactionDTO.deadline) && Objects.equals(this.minRemovalDelta, multisigAccountModificationTransactionDTO.minRemovalDelta) && Objects.equals(this.minApprovalDelta, multisigAccountModificationTransactionDTO.minApprovalDelta) && Objects.equals(this.modifications, multisigAccountModificationTransactionDTO.modifications);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.signerPublicKey, this.version, this.type, this.maxFee, this.deadline, this.minRemovalDelta, this.minApprovalDelta, this.modifications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigAccountModificationTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    minRemovalDelta: ").append(this.toIndentedString(this.minRemovalDelta)).append("\n");
        sb.append("    minApprovalDelta: ").append(this.toIndentedString(this.minApprovalDelta)).append("\n");
        sb.append("    modifications: ").append(this.toIndentedString(this.modifications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

