/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.CosignatureDTO;
import io.nem.sdk.openapi.jersey2.model.EmbeddedTransactionInfoDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Transaction to combine multiple transactions together.")
public class AggregateBondedTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    @JsonProperty(value="signature")
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    @JsonProperty(value="signerPublicKey")
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    @JsonProperty(value="maxFee")
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    @JsonProperty(value="deadline")
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_COSIGNATURES = "cosignatures";
    @JsonProperty(value="cosignatures")
    private List<CosignatureDTO> cosignatures = new ArrayList<CosignatureDTO>();
    public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
    @JsonProperty(value="transactions")
    private List<EmbeddedTransactionInfoDTO> transactions = new ArrayList<EmbeddedTransactionInfoDTO>();

    public AggregateBondedTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AggregateBondedTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public AggregateBondedTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="36867", required=true, value="Entity version. The higher byte represents the network identifier: * 0x68 (MAIN_NET) - Public main network. * 0x98 (TEST_NET) - Public test network. * 0x60 (MIJIN) - Private network. * 0x90 (MIJIN_TEST) - Private test network. ")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AggregateBondedTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AggregateBondedTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public AggregateBondedTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public AggregateBondedTransactionDTO cosignatures(List<CosignatureDTO> cosignatures) {
        this.cosignatures = cosignatures;
        return this;
    }

    public AggregateBondedTransactionDTO addCosignaturesItem(CosignatureDTO cosignaturesItem) {
        this.cosignatures.add(cosignaturesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of transaction cosignatures.")
    public List<CosignatureDTO> getCosignatures() {
        return this.cosignatures;
    }

    public void setCosignatures(List<CosignatureDTO> cosignatures) {
        this.cosignatures = cosignatures;
    }

    public AggregateBondedTransactionDTO transactions(List<EmbeddedTransactionInfoDTO> transactions) {
        this.transactions = transactions;
        return this;
    }

    public AggregateBondedTransactionDTO addTransactionsItem(EmbeddedTransactionInfoDTO transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of transactions initiated by different accounts.")
    public List<EmbeddedTransactionInfoDTO> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<EmbeddedTransactionInfoDTO> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateBondedTransactionDTO aggregateBondedTransactionDTO = (AggregateBondedTransactionDTO)o;
        return Objects.equals(this.signature, aggregateBondedTransactionDTO.signature) && Objects.equals(this.signerPublicKey, aggregateBondedTransactionDTO.signerPublicKey) && Objects.equals(this.version, aggregateBondedTransactionDTO.version) && Objects.equals(this.type, aggregateBondedTransactionDTO.type) && Objects.equals(this.maxFee, aggregateBondedTransactionDTO.maxFee) && Objects.equals(this.deadline, aggregateBondedTransactionDTO.deadline) && Objects.equals(this.cosignatures, aggregateBondedTransactionDTO.cosignatures) && Objects.equals(this.transactions, aggregateBondedTransactionDTO.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.signerPublicKey, this.version, this.type, this.maxFee, this.deadline, this.cosignatures, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateBondedTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    cosignatures: ").append(this.toIndentedString(this.cosignatures)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

