package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.sdk.openapi.jersey2.model.ModelError;
import io.nem.sdk.openapi.jersey2.model.MosaicIds;
import io.nem.sdk.openapi.jersey2.model.MosaicInfoDTO;
import io.nem.sdk.openapi.jersey2.model.MosaicsNamesDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-11-02T09:22:19.033Z[UTC]")
public class MosaicRoutesApi {
  private ApiClient apiClient;

  public MosaicRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MosaicRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get mosaic information
   * Gets the mosaic definition for a given mosaic identifier.
   * @param mosaicId Mosaic identifier. (required)
   * @return MosaicInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MosaicInfoDTO getMosaic(String mosaicId) throws ApiException {
    return getMosaicWithHttpInfo(mosaicId).getData();
      }

  /**
   * Get mosaic information
   * Gets the mosaic definition for a given mosaic identifier.
   * @param mosaicId Mosaic identifier. (required)
   * @return ApiResponse&lt;MosaicInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MosaicInfoDTO> getMosaicWithHttpInfo(String mosaicId) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'mosaicId' is set
    if (mosaicId == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicId' when calling getMosaic");
    }
    
    // create path and map variables
    String localVarPath = "/mosaic/{mosaicId}"
      .replaceAll("\\{" + "mosaicId" + "\\}", apiClient.escapeString(mosaicId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MosaicInfoDTO> localVarReturnType = new GenericType<MosaicInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get mosaics information for an array of mosaics
   * Gets an array of mosaic definition.
   * @param mosaicIds  (required)
   * @return List&lt;MosaicInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<MosaicInfoDTO> getMosaics(MosaicIds mosaicIds) throws ApiException {
    return getMosaicsWithHttpInfo(mosaicIds).getData();
      }

  /**
   * Get mosaics information for an array of mosaics
   * Gets an array of mosaic definition.
   * @param mosaicIds  (required)
   * @return ApiResponse&lt;List&lt;MosaicInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<MosaicInfoDTO>> getMosaicsWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
    Object localVarPostBody = mosaicIds;
    
    // verify the required parameter 'mosaicIds' is set
    if (mosaicIds == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaics");
    }
    
    // create path and map variables
    String localVarPath = "/mosaic";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<MosaicInfoDTO>> localVarReturnType = new GenericType<List<MosaicInfoDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get readable names for a set of mosaics
   * Returns friendly names for mosaics.
   * @param mosaicIds  (required)
   * @return MosaicsNamesDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MosaicsNamesDTO getMosaicsNames(MosaicIds mosaicIds) throws ApiException {
    return getMosaicsNamesWithHttpInfo(mosaicIds).getData();
      }

  /**
   * Get readable names for a set of mosaics
   * Returns friendly names for mosaics.
   * @param mosaicIds  (required)
   * @return ApiResponse&lt;MosaicsNamesDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> InvalidContent </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MosaicsNamesDTO> getMosaicsNamesWithHttpInfo(MosaicIds mosaicIds) throws ApiException {
    Object localVarPostBody = mosaicIds;
    
    // verify the required parameter 'mosaicIds' is set
    if (mosaicIds == null) {
      throw new ApiException(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames");
    }
    
    // create path and map variables
    String localVarPath = "/mosaic/names";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MosaicsNamesDTO> localVarReturnType = new GenericType<MosaicsNamesDTO>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
