/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.CosignatoryModificationDTO;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultisigAccountModificationTransactionBodyDTO {
    public static final String JSON_PROPERTY_MIN_REMOVAL_DELTA = "minRemovalDelta";
    @JsonProperty(value="minRemovalDelta")
    private Integer minRemovalDelta;
    public static final String JSON_PROPERTY_MIN_APPROVAL_DELTA = "minApprovalDelta";
    @JsonProperty(value="minApprovalDelta")
    private Integer minApprovalDelta;
    public static final String JSON_PROPERTY_MODIFICATIONS = "modifications";
    @JsonProperty(value="modifications")
    private List<CosignatoryModificationDTO> modifications = new ArrayList<CosignatoryModificationDTO>();

    public MultisigAccountModificationTransactionBodyDTO minRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    public Integer getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public void setMinRemovalDelta(Integer minRemovalDelta) {
        this.minRemovalDelta = minRemovalDelta;
    }

    public MultisigAccountModificationTransactionBodyDTO minApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
    public Integer getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    public void setMinApprovalDelta(Integer minApprovalDelta) {
        this.minApprovalDelta = minApprovalDelta;
    }

    public MultisigAccountModificationTransactionBodyDTO modifications(List<CosignatoryModificationDTO> modifications) {
        this.modifications = modifications;
        return this;
    }

    public MultisigAccountModificationTransactionBodyDTO addModificationsItem(CosignatoryModificationDTO modificationsItem) {
        this.modifications.add(modificationsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of cosignatory accounts to add or delete.")
    public List<CosignatoryModificationDTO> getModifications() {
        return this.modifications;
    }

    public void setModifications(List<CosignatoryModificationDTO> modifications) {
        this.modifications = modifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigAccountModificationTransactionBodyDTO multisigAccountModificationTransactionBodyDTO = (MultisigAccountModificationTransactionBodyDTO)o;
        return Objects.equals(this.minRemovalDelta, multisigAccountModificationTransactionBodyDTO.minRemovalDelta) && Objects.equals(this.minApprovalDelta, multisigAccountModificationTransactionBodyDTO.minApprovalDelta) && Objects.equals(this.modifications, multisigAccountModificationTransactionBodyDTO.modifications);
    }

    public int hashCode() {
        return Objects.hash(this.minRemovalDelta, this.minApprovalDelta, this.modifications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigAccountModificationTransactionBodyDTO {\n");
        sb.append("    minRemovalDelta: ").append(this.toIndentedString(this.minRemovalDelta)).append("\n");
        sb.append("    minApprovalDelta: ").append(this.toIndentedString(this.minApprovalDelta)).append("\n");
        sb.append("    modifications: ").append(this.toIndentedString(this.modifications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

