/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.openapi.jersey2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.nem.sdk.openapi.jersey2.model.ReceiptTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Invisible state change that changed an account balance.")
public class BalanceChangeReceiptDTO {
    public static final String JSON_PROPERTY_VERSION = "version";
    @JsonProperty(value="version")
    private Integer version;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private ReceiptTypeEnum type;
    public static final String JSON_PROPERTY_TARGET_PUBLIC_KEY = "targetPublicKey";
    @JsonProperty(value="targetPublicKey")
    private String targetPublicKey;
    public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
    @JsonProperty(value="mosaicId")
    private String mosaicId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    @JsonProperty(value="amount")
    private BigInteger amount = null;

    public BalanceChangeReceiptDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Version of the receipt.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BalanceChangeReceiptDTO type(ReceiptTypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ReceiptTypeEnum getType() {
        return this.type;
    }

    public void setType(ReceiptTypeEnum type) {
        this.type = type;
    }

    public BalanceChangeReceiptDTO targetPublicKey(String targetPublicKey) {
        this.targetPublicKey = targetPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="")
    public String getTargetPublicKey() {
        return this.targetPublicKey;
    }

    public void setTargetPublicKey(String targetPublicKey) {
        this.targetPublicKey = targetPublicKey;
    }

    public BalanceChangeReceiptDTO mosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    public String getMosaicId() {
        return this.mosaicId;
    }

    public void setMosaicId(String mosaicId) {
        this.mosaicId = mosaicId;
    }

    public BalanceChangeReceiptDTO amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceChangeReceiptDTO balanceChangeReceiptDTO = (BalanceChangeReceiptDTO)o;
        return Objects.equals(this.version, balanceChangeReceiptDTO.version) && Objects.equals((Object)this.type, (Object)balanceChangeReceiptDTO.type) && Objects.equals(this.targetPublicKey, balanceChangeReceiptDTO.targetPublicKey) && Objects.equals(this.mosaicId, balanceChangeReceiptDTO.mosaicId) && Objects.equals(this.amount, balanceChangeReceiptDTO.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.type, this.targetPublicKey, this.mosaicId, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceChangeReceiptDTO {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    targetPublicKey: ").append(this.toIndentedString(this.targetPublicKey)).append("\n");
        sb.append("    mosaicId: ").append(this.toIndentedString(this.mosaicId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

