package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.sdk.openapi.jersey2.model.NodeInfoDTO;
import io.nem.sdk.openapi.jersey2.model.NodeTimeDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-10-15T22:22:43.352+02:00[Europe/Madrid]")
public class NodeRoutesApi {
  private ApiClient apiClient;

  public NodeRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public NodeRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get the node information
   * Supplies additional information about the application running on a node.
   * @return NodeInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public NodeInfoDTO getNodeInfo() throws ApiException {
    return getNodeInfoWithHttpInfo().getData();
      }

  /**
   * Get the node information
   * Supplies additional information about the application running on a node.
   * @return ApiResponse&lt;NodeInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NodeInfoDTO> getNodeInfoWithHttpInfo() throws ApiException {
    Object localVarPostBody = new Object();
    
    // create path and map variables
    String localVarPath = "/node/info";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NodeInfoDTO> localVarReturnType = new GenericType<NodeInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the node time
   * Gets the node time at the moment the reply was sent and received.
   * @return NodeTimeDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public NodeTimeDTO getNodeTime() throws ApiException {
    return getNodeTimeWithHttpInfo().getData();
      }

  /**
   * Get the node time
   * Gets the node time at the moment the reply was sent and received.
   * @return ApiResponse&lt;NodeTimeDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<NodeTimeDTO> getNodeTimeWithHttpInfo() throws ApiException {
    Object localVarPostBody = new Object();
    
    // create path and map variables
    String localVarPath = "/node/time";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<NodeTimeDTO> localVarReturnType = new GenericType<NodeTimeDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
