package io.nem.sdk.openapi.jersey2.api;

import io.nem.sdk.openapi.jersey2.invoker.ApiException;
import io.nem.sdk.openapi.jersey2.invoker.ApiClient;
import io.nem.sdk.openapi.jersey2.invoker.ApiResponse;
import io.nem.sdk.openapi.jersey2.invoker.Configuration;
import io.nem.sdk.openapi.jersey2.invoker.Pair;

import javax.ws.rs.core.GenericType;

import io.nem.sdk.openapi.jersey2.model.BlockInfoDTO;
import io.nem.sdk.openapi.jersey2.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.jersey2.model.ModelError;
import io.nem.sdk.openapi.jersey2.model.StatementsDTO;
import io.nem.sdk.openapi.jersey2.model.TransactionInfoDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2019-10-15T22:22:43.352+02:00[Europe/Madrid]")
public class BlockRoutesApi {
  private ApiClient apiClient;

  public BlockRoutesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public BlockRoutesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get block information
   * Gets a block from the chain that has the given height.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @return BlockInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public BlockInfoDTO getBlockByHeight(Long height) throws ApiException {
    return getBlockByHeightWithHttpInfo(height).getData();
      }

  /**
   * Get block information
   * Gets a block from the chain that has the given height.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @return ApiResponse&lt;BlockInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<BlockInfoDTO> getBlockByHeightWithHttpInfo(Long height) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockByHeight");
    }
    
    // create path and map variables
    String localVarPath = "/block/{height}"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<BlockInfoDTO> localVarReturnType = new GenericType<BlockInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get receipts from a block
   * Returns the receipts linked to a block.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @return StatementsDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public StatementsDTO getBlockReceipts(Long height) throws ApiException {
    return getBlockReceiptsWithHttpInfo(height).getData();
      }

  /**
   * Get receipts from a block
   * Returns the receipts linked to a block.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @return ApiResponse&lt;StatementsDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<StatementsDTO> getBlockReceiptsWithHttpInfo(Long height) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockReceipts");
    }
    
    // create path and map variables
    String localVarPath = "/block/{height}/receipts"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<StatementsDTO> localVarReturnType = new GenericType<StatementsDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get transactions from a block
   * Returns an array of transactions included in a block for a given block height.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Transaction identifier up to which transactions are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return List&lt;TransactionInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<TransactionInfoDTO> getBlockTransactions(Long height, Integer pageSize, String id, String ordering) throws ApiException {
    return getBlockTransactionsWithHttpInfo(height, pageSize, id, ordering).getData();
      }

  /**
   * Get transactions from a block
   * Returns an array of transactions included in a block for a given block height.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param pageSize Number of transactions to return for each request. (optional, default to 10)
   * @param id Transaction identifier up to which transactions are returned. (optional)
   * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
   * @return ApiResponse&lt;List&lt;TransactionInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<TransactionInfoDTO>> getBlockTransactionsWithHttpInfo(Long height, Integer pageSize, String id, String ordering) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getBlockTransactions");
    }
    
    // create path and map variables
    String localVarPath = "/block/{height}/transactions"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "ordering", ordering));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<TransactionInfoDTO>> localVarReturnType = new GenericType<List<TransactionInfoDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get blocks information
   * Gets up to limit number of blocks after given block height.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param limit Number of elements to be returned. (required)
   * @return List&lt;BlockInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public List<BlockInfoDTO> getBlocksByHeightWithLimit(Long height, Integer limit) throws ApiException {
    return getBlocksByHeightWithLimitWithHttpInfo(height, limit).getData();
      }

  /**
   * Get blocks information
   * Gets up to limit number of blocks after given block height.
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param limit Number of elements to be returned. (required)
   * @return ApiResponse&lt;List&lt;BlockInfoDTO&gt;&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<List<BlockInfoDTO>> getBlocksByHeightWithLimitWithHttpInfo(Long height, Integer limit) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getBlocksByHeightWithLimit");
    }
    
    // verify the required parameter 'limit' is set
    if (limit == null) {
      throw new ApiException(400, "Missing the required parameter 'limit' when calling getBlocksByHeightWithLimit");
    }
    
    // create path and map variables
    String localVarPath = "/blocks/{height}/limit/{limit}"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()))
      .replaceAll("\\{" + "limit" + "\\}", apiClient.escapeString(limit.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<List<BlockInfoDTO>> localVarReturnType = new GenericType<List<BlockInfoDTO>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the merkle path for a given a receipt statement hash and block
   * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param hash Receipt hash. (required)
   * @return MerkleProofInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MerkleProofInfoDTO getMerkleReceipts(Long height, String hash) throws ApiException {
    return getMerkleReceiptsWithHttpInfo(height, hash).getData();
      }

  /**
   * Get the merkle path for a given a receipt statement hash and block
   * Returns the merkle path for a receipt statement or resolution linked to a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the receipt was linked with the block. 
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param hash Receipt hash. (required)
   * @return ApiResponse&lt;MerkleProofInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MerkleProofInfoDTO> getMerkleReceiptsWithHttpInfo(Long height, String hash) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleReceipts");
    }
    
    // verify the required parameter 'hash' is set
    if (hash == null) {
      throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleReceipts");
    }
    
    // create path and map variables
    String localVarPath = "/block/{height}/receipt/{hash}/merkle"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()))
      .replaceAll("\\{" + "hash" + "\\}", apiClient.escapeString(hash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get the merkle path for a given a transaction and block
   * Returns the merkle path for a transaction included in a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the transaction was included in the block. 
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param hash Transaction hash. (required)
   * @return MerkleProofInfoDTO
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public MerkleProofInfoDTO getMerkleTransaction(Long height, String hash) throws ApiException {
    return getMerkleTransactionWithHttpInfo(height, hash).getData();
      }

  /**
   * Get the merkle path for a given a transaction and block
   * Returns the merkle path for a transaction included in a block. The path is the complementary data needed to calculate the merkle root. A client can compare if the calculated root equals the one recorded in the block header, verifying that the transaction was included in the block. 
   * @param height Block height. If height -1 is not a multiple of the limit provided, the inferior closest multiple + 1 is used instead. (required)
   * @param hash Transaction hash. (required)
   * @return ApiResponse&lt;MerkleProofInfoDTO&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> success </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> ResourceNotFound </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> InvalidArgument </td><td>  -  </td></tr>
     </table>
   */
  public ApiResponse<MerkleProofInfoDTO> getMerkleTransactionWithHttpInfo(Long height, String hash) throws ApiException {
    Object localVarPostBody = new Object();
    
    // verify the required parameter 'height' is set
    if (height == null) {
      throw new ApiException(400, "Missing the required parameter 'height' when calling getMerkleTransaction");
    }
    
    // verify the required parameter 'hash' is set
    if (hash == null) {
      throw new ApiException(400, "Missing the required parameter 'hash' when calling getMerkleTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/block/{height}/transaction/{hash}/merkle"
      .replaceAll("\\{" + "height" + "\\}", apiClient.escapeString(height.toString()))
      .replaceAll("\\{" + "hash" + "\\}", apiClient.escapeString(hash.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<MerkleProofInfoDTO> localVarReturnType = new GenericType<MerkleProofInfoDTO>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
