/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.support;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HeaderConsumer
implements Consumer<HttpHeaders> {
    private static final String ACTOR_ID_KEY = "actorId";
    private static final String PUBLIC_SERVANT_ID_KEY = "publicServantId";
    private static final List<String> HEADER_KEYS = Arrays.asList("actorId", "publicServantId", "Authorization", "Cookie");

    @Override
    public void accept(HttpHeaders httpHeaders) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        HttpServletRequest request = requestAttributes.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            httpHeaders.add(headerName, request.getHeader(headerName));
        }
    }
}

