/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.security;

import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceAuthenticationFilter;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceExceptionResolver;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestBuilder;
import io.naradrama.prologue.util.spacekeeper.filter.drama.DramaRequest;
import io.naradrama.prologue.util.spacekeeper.filter.metro.MetroRequest;
import io.naradrama.prologue.util.spacekeeper.filter.support.SpaceAuthenticationMockFilter;
import io.naradrama.prologue.util.spacekeeper.security.PublicResourceEndPointHolder;
import io.naradrama.prologue.util.spacekeeper.security.PublicResourceMatcher;
import io.naradrama.prologue.util.spacekeeper.security.SpaceAuthenticationEntryPoint;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableResourceServer
@ConditionalOnWebApplication
@ConditionalOnMissingClass(value={"io.naraplatform.checkpoint.config.OAuth2ResourceServerConfig"})
public class SpaceResourceServerConfig
extends ResourceServerConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SpaceResourceServerConfig.class);
    @Value(value="${nara.signing_key:naraBizAdmin1!!}")
    private String jwtSigningKey;
    @Value(value="${spring.profiles.active:default}")
    private List<String> activeProfiles;
    @Value(value="${nara.prologue.test-profiles:default,k8s_test}")
    private List<String> testProfiles;
    private final SpaceRequestBuilder requestBuilder;
    private final SpaceAuthenticationEntryPoint entryPoint;
    private final PublicResourceEndPointHolder endPointHolder;
    @Value(value="${nara.sample_drama_request.actorId:1@1:1:1-1}")
    private String sampleDramaActorId;
    @Value(value="${nara.sample_drama_request.loginId:user@company.io}")
    private String sampleDramaLoginId;
    @Value(value="${nara.sample_drama_request.displayName:User}")
    private String sampleDramaDisplayName;
    @Value(value="${nara.sample_drama_request.citizenId:1@1:1}")
    private String sampleDramaCitizenId;
    @Value(value="${nara.sample_drama_request.cineroomIds:1:1,1:2,1:3}")
    private List<String> sampleDramaCineroomIds;
    @Value(value="${nara.sample_metro_request.currentServantId:1#1:1}")
    private String sampleMetroCurrentServantId;
    @Value(value="${nara.sample_metro_request.currentServantType:PavilionServant}")
    private ServantType sampleMetroCurrentServantType;
    @Value(value="${nara.sample_sample_request.loginEmailId:admin@company.io}")
    private String sampleMetroLoginEmailId;
    @Value(value="${nara.sample_sample_request.displayName:Admin}")
    private String sampleMetroDisplayName;
    @Value(value="${nara.sample_sample_request.servantId:56864624-5c08-46c2-9105-c2bd21171461}")
    private String sampleMetroServantId;
    @Value(value="${nara.sample_sample_request.officeIds:S1,1,1:1}")
    private List<String> sampleMetroOfficeIds;
    @Value(value="${nara.sample_sample_request.sampleAccessibleCitizen:false}")
    private Boolean sampleAccessibleCitizen;

    public void configure(HttpSecurity http) throws Exception {
        if (!this.testProfiles.isEmpty() && this.testProfiles.stream().anyMatch(authIgnoreProfile -> this.activeProfiles.contains(authIgnoreProfile))) {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/**"})).permitAll().and()).addFilterBefore((Filter)new SpaceAuthenticationMockFilter(this.requestBuilder, this.endPointHolder, this.sampleDramaRequest(), this.sampleMetroRequest()), BasicAuthenticationFilter.class).addFilterBefore((Filter)new SpaceExceptionResolver(), SpaceAuthenticationMockFilter.class);
            log.info("Space keeper authentication was disabled by test profiles={}", this.activeProfiles);
        } else {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().requestMatchers(new RequestMatcher[]{new PublicResourceMatcher(this.endPointHolder)})).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/swagger-ui.html**", "/swagger-resources/**", "/actuator/**", "/v2/api-docs/**", "/webjars/**"})).permitAll().and()).authorizeRequests().anyRequest()).authenticated().and()).addFilterAfter((Filter)new SpaceAuthenticationFilter(this.requestBuilder, this.endPointHolder), AnonymousAuthenticationFilter.class).addFilterBefore((Filter)new SpaceExceptionResolver(), SpaceAuthenticationFilter.class);
            log.info("Space keeper authentication was activated");
            log.info("Registered filter list={}", Arrays.asList(SpaceAuthenticationFilter.class.getSimpleName()));
        }
    }

    public void configure(ResourceServerSecurityConfigurer config) {
        config.tokenServices((ResourceServerTokenServices)this.tokenServices());
        config.authenticationEntryPoint((AuthenticationEntryPoint)this.entryPoint);
    }

    @Bean
    public TokenStore tokenStore() {
        return new JwtTokenStore(this.jwtAccessTokenConverter());
    }

    @Primary
    @Bean
    public DefaultTokenServices tokenServices() {
        DefaultTokenServices defaultTokenServices = new DefaultTokenServices();
        defaultTokenServices.setTokenStore(this.tokenStore());
        defaultTokenServices.setSupportRefreshToken(true);
        return defaultTokenServices;
    }

    @Bean
    public JwtAccessTokenConverter jwtAccessTokenConverter() {
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        converter.setSigningKey(this.jwtSigningKey);
        return converter;
    }

    public DramaRequest sampleDramaRequest() {
        return new DramaRequest(this.sampleDramaActorId, this.sampleDramaLoginId, this.sampleDramaDisplayName, this.sampleDramaCitizenId, this.sampleDramaCineroomIds);
    }

    public MetroRequest sampleMetroRequest() {
        return new MetroRequest(this.sampleMetroCurrentServantId, this.sampleMetroCurrentServantType, this.sampleMetroLoginEmailId, this.sampleMetroDisplayName, this.sampleMetroServantId, this.sampleMetroOfficeIds, this.sampleAccessibleCitizen);
    }

    public SpaceResourceServerConfig(SpaceRequestBuilder requestBuilder, SpaceAuthenticationEntryPoint entryPoint, PublicResourceEndPointHolder endPointHolder) {
        this.requestBuilder = requestBuilder;
        this.entryPoint = entryPoint;
        this.endPointHolder = endPointHolder;
    }
}

