/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.security;

import io.naradrama.prologue.util.json.JsonUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class SpaceAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(SpaceAuthenticationEntryPoint.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException {
        log.error("Authentication exception, message=" + e.getMessage(), (Throwable)e);
        ServletServerHttpResponse serverResponse = new ServletServerHttpResponse(response);
        serverResponse.setStatusCode(HttpStatus.UNAUTHORIZED);
        serverResponse.getServletResponse().setHeader("Content-Type", "application/json");
        serverResponse.getBody().write(JsonUtil.toJson(e).getBytes());
    }
}

