/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.security;

import io.naradrama.prologue.util.spacekeeper.security.PublicResourceEndPointHolder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class PublicResourceMatcher
implements RequestMatcher {
    private static final Logger log = LoggerFactory.getLogger(PublicResourceMatcher.class);
    private final PublicResourceEndPointHolder endPointHolder;

    public boolean matches(HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        String requestUri = httpServletRequest.getRequestURI();
        if (this.endPointHolder.isPublic(requestUri)) {
            log.debug("Permit all using AuthorizedRole(isPublic=true), URI={}", (Object)requestUri);
            return true;
        }
        if (!requestUri.startsWith("/secure/")) {
            log.debug("Permit none secure resource (ex: internal calls)", (Object)requestUri);
            return true;
        }
        return false;
    }

    public PublicResourceMatcher(PublicResourceEndPointHolder endPointHolder) {
        this.endPointHolder = endPointHolder;
    }
}

