/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.security;

import io.naradrama.prologue.domain.drama.AuthorizedRole;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class PublicResourceEndPointHolder {
    private static final Logger log = LoggerFactory.getLogger(PublicResourceEndPointHolder.class);
    private static final String PUBLIC = "isPublic";
    private Set<String> publicUrlSet = new HashSet<String>();

    @EventListener
    public void handleContextRefresh(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map map = requestMappingHandlerMapping.getHandlerMethods();
        map.forEach((mapping, method) -> {
            boolean isPublicMapping = this.parsePublicRole(method.getBeanType().getAnnotations()) || this.parsePublicRole(method.getMethod().getAnnotations());
            mapping.getPatternsCondition().getPatterns().forEach(pattern -> {
                if (isPublicMapping) {
                    log.debug("{}.{}: {} is public", new Object[]{method.getBeanType().getSimpleName(), method.getMethod().getName(), pattern});
                    this.publicUrlSet.add((String)pattern);
                } else if (!pattern.startsWith("/secure/")) {
                    this.publicUrlSet.add((String)pattern);
                }
            });
        });
    }

    public boolean isPublic(String url) {
        if (this.publicUrlSet.contains(url)) {
            return true;
        }
        if (url.endsWith("/")) {
            String alternativeUrl = url.substring(0, url.length() - 1);
            return this.publicUrlSet.contains(alternativeUrl);
        }
        return false;
    }

    private boolean parsePublicRole(Annotation[] annotations) {
        return Arrays.stream(annotations).anyMatch(annotation -> {
            if (annotation.annotationType().equals(AuthorizedRole.class)) {
                try {
                    Method annotationMethod = Arrays.stream(annotation.annotationType().getMethods()).filter(method -> method.getName().equals(PUBLIC)).findFirst().orElse(null);
                    return Boolean.parseBoolean(annotationMethod.invoke(annotation, (Object[])null).toString());
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        });
    }
}

