/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.filter.support;

import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestBuilder;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestContext;
import io.naradrama.prologue.util.spacekeeper.filter.drama.DramaRequest;
import io.naradrama.prologue.util.spacekeeper.filter.metro.MetroRequest;
import io.naradrama.prologue.util.spacekeeper.filter.metro.MetroRequestBuilder;
import io.naradrama.prologue.util.spacekeeper.security.PublicResourceEndPointHolder;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpaceAuthenticationMockFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(SpaceAuthenticationMockFilter.class);
    private final SpaceRequestBuilder requestBuilder;
    private final PublicResourceEndPointHolder endPointHolder;
    private final DramaRequest sampleDramaRequest;
    private final MetroRequest sampleMetroRequest;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requestBuilder instanceof MetroRequestBuilder) {
            SpaceRequestContext.setCurrentRequest(this.sampleDramaRequest);
        } else {
            SpaceRequestContext.setCurrentRequest(this.sampleMetroRequest);
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        finally {
            this.requestBuilder.clearRequest();
        }
    }

    public SpaceAuthenticationMockFilter(SpaceRequestBuilder requestBuilder, PublicResourceEndPointHolder endPointHolder, DramaRequest sampleDramaRequest, MetroRequest sampleMetroRequest) {
        this.requestBuilder = requestBuilder;
        this.endPointHolder = endPointHolder;
        this.sampleDramaRequest = sampleDramaRequest;
        this.sampleMetroRequest = sampleMetroRequest;
    }
}

