/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.filter.metro;

import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestBuilder;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestContext;
import io.naradrama.prologue.util.spacekeeper.filter.metro.MetroRequest;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetroRequestBuilder
implements SpaceRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(MetroRequestBuilder.class);
    private static final String BACK_STAGE_SERVANT_ID_NAME = "backStageServantId";
    private static final String PAVILION_SERVANT_ID_NAME = "pavilionServantId";
    private static final String SQUARE_SERVANT_ID_NAME = "squareServantId";
    private static final String PUBLIC_SERVANT_ID_NAME = "publicServantId";
    private static final String STATION_SERVANT_ID_NAME = "stationServantId";
    private static final String CINEROOM_SERVANT_ID_NAME = "cineroomServantId";
    private static final String CITIZEN_ID_NAME = "citizenId";
    private static final Base64.Decoder decoder = Base64.getDecoder();

    @Override
    public void buildRequest(HttpServletRequest request) {
        MetroRequest currentRequest = this.createCurrentRequest(request);
        SpaceRequestContext.setCurrentRequest(currentRequest);
    }

    @Override
    public void clearRequest() {
        SpaceRequestContext.clearCurrentRequest();
    }

    public MetroRequest createCurrentRequest(HttpServletRequest request) {
        ServantType currentServantType = this.getCurrentServantType(request);
        String currentServantId = this.getCurrentServantId(request, currentServantType);
        Map<String, Object> payload = this.getPayloadFromRequest(request);
        Boolean accessibleCitizen = false;
        if (payload != null && payload.get(CITIZEN_ID_NAME) != null) {
            String headerCitizenId = this.getCurrentCitizenId(request);
            String citizenId = (String)payload.get(CITIZEN_ID_NAME);
            accessibleCitizen = headerCitizenId.equals(citizenId);
        }
        log.debug("Create current request, currentServantType={}, currentServantId={}, payload={}", new Object[]{currentServantType, currentServantId, payload});
        if (payload != null) {
            return new MetroRequest(currentServantId, currentServantType, (String)payload.get("loginEmailId"), (String)payload.get("displayName"), (String)payload.get(PUBLIC_SERVANT_ID_NAME), (List)payload.get("officeIds"), accessibleCitizen);
        }
        return null;
    }

    private ServantType getCurrentServantType(HttpServletRequest request) {
        if (request.getHeader(PUBLIC_SERVANT_ID_NAME) != null) {
            return ServantType.PublicServant;
        }
        if (request.getHeader(CINEROOM_SERVANT_ID_NAME) != null) {
            return ServantType.CineroomServant;
        }
        if (request.getHeader(BACK_STAGE_SERVANT_ID_NAME) != null) {
            return ServantType.BackStageServant;
        }
        if (request.getHeader(PAVILION_SERVANT_ID_NAME) != null) {
            return ServantType.PavilionServant;
        }
        if (request.getHeader(SQUARE_SERVANT_ID_NAME) != null) {
            return ServantType.SquareServant;
        }
        if (request.getHeader(STATION_SERVANT_ID_NAME) != null) {
            return ServantType.StationServant;
        }
        return null;
    }

    private String getCurrentCitizenId(HttpServletRequest request) {
        String citizenId = "";
        if (request.getHeader(CITIZEN_ID_NAME) != null) {
            citizenId = request.getHeader(CITIZEN_ID_NAME);
        }
        return citizenId;
    }

    private String getCurrentServantId(HttpServletRequest request, ServantType servantType) {
        String currentServantId = null;
        if (servantType != null) {
            switch (servantType) {
                case PublicServant: {
                    currentServantId = request.getHeader(PUBLIC_SERVANT_ID_NAME);
                    break;
                }
                case CineroomServant: {
                    currentServantId = request.getHeader(CINEROOM_SERVANT_ID_NAME);
                    break;
                }
                case BackStageServant: {
                    currentServantId = request.getHeader(BACK_STAGE_SERVANT_ID_NAME);
                    break;
                }
                case PavilionServant: {
                    currentServantId = request.getHeader(PAVILION_SERVANT_ID_NAME);
                    break;
                }
                case SquareServant: {
                    currentServantId = request.getHeader(SQUARE_SERVANT_ID_NAME);
                    break;
                }
                case StationServant: {
                    currentServantId = request.getHeader(STATION_SERVANT_ID_NAME);
                }
            }
        }
        return currentServantId;
    }

    private Map<String, Object> getPayloadFromRequest(HttpServletRequest request) {
        if (request.getHeader("Authorization") != null) {
            String authorization = request.getHeader("Authorization");
            String token = authorization.substring("Bearer ".length());
            return JsonUtil.fromJson(this.getTokenPayload(token), Map.class);
        }
        return null;
    }

    private String getTokenPayload(String token) throws IllegalArgumentException {
        String[] chunks = token.split("\\.");
        return new String(decoder.decode(chunks[1]));
    }

    private MetroRequestBuilder() {
    }
}

