/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.filter.metro;

import io.naradrama.prologue.domain.granule.Email;
import io.naradrama.prologue.domain.office.CineroomServantKey;
import io.naradrama.prologue.domain.office.PavilionServantKey;
import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.domain.office.SquareServantKey;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequest;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MetroRequest
implements SpaceRequest {
    private static final Logger log = LoggerFactory.getLogger(MetroRequest.class);
    private String currentServantId;
    private ServantType currentServantType;
    private String loginEmailId;
    private String displayName;
    private String publicServantId;
    private List<String> officeIds;
    private Boolean accessibleCitizen;

    @Override
    public boolean hasAuthority() {
        String currentOfficeId = null;
        if (this.currentServantType != null && this.currentServantId != null && !CollectionUtils.isEmpty(this.officeIds)) {
            switch (this.currentServantType) {
                case PublicServant: {
                    return this.currentServantId.equals(this.publicServantId);
                }
                case CineroomServant: {
                    currentOfficeId = CineroomServantKey.fromId(this.currentServantId).genCineroomOfficeKey().getId();
                    break;
                }
                case BackStageServant: {
                    break;
                }
                case PavilionServant: {
                    currentOfficeId = PavilionServantKey.fromId(this.currentServantId).genPavilionOfficeKey().getId();
                    break;
                }
                case SquareServant: {
                    currentOfficeId = SquareServantKey.fromId(this.currentServantId).genSquareOfficeKey().getId();
                    break;
                }
                case StationServant: {
                    if (CollectionUtils.isEmpty(this.officeIds)) break;
                    currentOfficeId = this.officeIds.stream().filter(officeId -> officeId.startsWith("S")).findFirst().orElse(null);
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.officeIds)) {
            return this.officeIds.contains(currentOfficeId);
        }
        log.debug("Authorization was failed, currentServantType={}, currentServantId={}, currentOfficeId={}", new Object[]{this.currentServantType, this.currentServantId, currentOfficeId});
        return this.accessibleCitizen != false;
    }

    public String toString() {
        return this.toJson();
    }

    public static MetroRequest sample() {
        String currentServantId = "1#1:1";
        ServantType currentServantType = ServantType.PavilionServant;
        String loginEmailId = Email.sample().getEmail();
        String publicServantId = UUID.randomUUID().toString();
        String displayName = "Steve Jobs";
        List<String> officeIds = Arrays.asList("S1", "1", "1:1");
        Boolean accessibleCitizen = false;
        return new MetroRequest(currentServantId, currentServantType, loginEmailId, displayName, publicServantId, officeIds, accessibleCitizen);
    }

    public String getCurrentServantId() {
        return this.currentServantId;
    }

    public ServantType getCurrentServantType() {
        return this.currentServantType;
    }

    public String getLoginEmailId() {
        return this.loginEmailId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPublicServantId() {
        return this.publicServantId;
    }

    public List<String> getOfficeIds() {
        return this.officeIds;
    }

    public Boolean getAccessibleCitizen() {
        return this.accessibleCitizen;
    }

    public MetroRequest() {
    }

    public MetroRequest(String currentServantId, ServantType currentServantType, String loginEmailId, String displayName, String publicServantId, List<String> officeIds, Boolean accessibleCitizen) {
        this.currentServantId = currentServantId;
        this.currentServantType = currentServantType;
        this.loginEmailId = loginEmailId;
        this.displayName = displayName;
        this.publicServantId = publicServantId;
        this.officeIds = officeIds;
        this.accessibleCitizen = accessibleCitizen;
    }
}

