/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.filter.drama;

import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestBuilder;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestContext;
import io.naradrama.prologue.util.spacekeeper.filter.drama.DramaRequest;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DramaRequestBuilder
implements SpaceRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(DramaRequestBuilder.class);
    private static final String ACTOR_ID_NAME = "actorId";
    private static final Base64.Decoder decoder = Base64.getDecoder();

    @Override
    public void buildRequest(HttpServletRequest request) {
        DramaRequest currentRequest = this.createCurrentRequest(request);
        SpaceRequestContext.setCurrentRequest(currentRequest);
    }

    @Override
    public void clearRequest() {
        SpaceRequestContext.clearCurrentRequest();
    }

    private DramaRequest createCurrentRequest(HttpServletRequest request) {
        String actorId = this.getCurrentActorId(request);
        Map<String, Object> payload = this.getPayloadFromRequest(request);
        log.debug("Create current request, actorId={}, payload={}", (Object)actorId, payload);
        if (payload != null) {
            return new DramaRequest(actorId, (String)payload.get("loginId"), (String)payload.get("displayName"), (String)payload.get("citizenId"), (List)payload.get("cineroomIds"));
        }
        return null;
    }

    private String getCurrentActorId(HttpServletRequest request) {
        if (request.getHeader(ACTOR_ID_NAME) != null) {
            return request.getHeader(ACTOR_ID_NAME);
        }
        return null;
    }

    private Map<String, Object> getPayloadFromRequest(HttpServletRequest request) {
        if (request.getHeader("Authorization") != null) {
            String authorization = request.getHeader("Authorization");
            String token = authorization.substring("Bearer ".length());
            return JsonUtil.fromJson(this.getTokenPayload(token), Map.class);
        }
        return null;
    }

    private String getTokenPayload(String token) throws IllegalArgumentException {
        String[] chunks = token.split("\\.");
        return new String(decoder.decode(chunks[1]));
    }

    private DramaRequestBuilder() {
    }
}

