/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.filter.drama;

import io.naradrama.prologue.domain.granule.Email;
import io.naradrama.prologue.domain.stage.ActorKey;
import io.naradrama.prologue.domain.tenant.CineroomKey;
import io.naradrama.prologue.domain.tenant.CitizenKey;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequest;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DramaRequest
implements SpaceRequest {
    private static final Logger log = LoggerFactory.getLogger(DramaRequest.class);
    private String actorId;
    private String loginId;
    private String displayName;
    private String citizenId;
    private List<String> cineroomIds;

    @Override
    public boolean hasAuthority() {
        String currentCineroomId = null;
        if (this.actorId != null && !CollectionUtils.isEmpty(this.cineroomIds)) {
            currentCineroomId = ActorKey.fromId(this.actorId).genCineroomKey().getId();
        }
        if (!CollectionUtils.isEmpty(this.cineroomIds)) {
            return this.cineroomIds.contains(currentCineroomId);
        }
        log.debug("Authorization was failed, actorId={}, currentCineroomId={}", (Object)this.actorId, (Object)currentCineroomId);
        return false;
    }

    public String toString() {
        return this.toJson();
    }

    public static DramaRequest sample() {
        String actorId = ActorKey.sample().getId();
        String loginId = Email.sample().getEmail();
        String displayName = "Steve Jobs";
        String citizenId = CitizenKey.sample().getId();
        List<String> cineroomIds = Arrays.asList(CineroomKey.sample().getId());
        return new DramaRequest(actorId, loginId, displayName, citizenId, cineroomIds);
    }

    public String getActorId() {
        return this.actorId;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCitizenId() {
        return this.citizenId;
    }

    public List<String> getCineroomIds() {
        return this.cineroomIds;
    }

    public DramaRequest() {
    }

    public DramaRequest(String actorId, String loginId, String displayName, String citizenId, List<String> cineroomIds) {
        this.actorId = actorId;
        this.loginId = loginId;
        this.displayName = displayName;
        this.citizenId = citizenId;
        this.cineroomIds = cineroomIds;
    }
}

