/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.filter;

import io.naradrama.prologue.domain.cqrs.FailureMessage;
import io.naradrama.prologue.domain.cqrs.command.CqrsCommand;
import io.naradrama.prologue.domain.cqrs.query.CqrsQuery;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.spacekeeper.filter.support.CachedBodyHttpServletRequest;
import io.naradrama.prologue.util.spacekeeper.filter.support.RequestedCqrsCommand;
import io.naradrama.prologue.util.spacekeeper.filter.support.RequestedCqrsQuery;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpaceExceptionResolver
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(SpaceExceptionResolver.class);
    private static final String X_RESULT = "X-Result";
    private static final String X_EXCEPTION_MESSGE = "X-Exception-Message";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object currentdRequest = request;
        if (HttpMethod.valueOf((String)request.getMethod()) == HttpMethod.POST && request.getHeader("Content-Type").contains("application/json")) {
            currentdRequest = new CachedBodyHttpServletRequest(request);
        }
        try {
            chain.doFilter((ServletRequest)currentdRequest, (ServletResponse)response);
            response.setHeader(X_RESULT, "true");
        }
        catch (IOException | ServletException e) {
            this.handleException(e, (HttpServletRequest)currentdRequest, response);
        }
    }

    private void handleException(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Throwable currentException = exception;
        if (exception.getCause() != null) {
            currentException = exception.getCause();
        }
        if (currentException instanceof AccessDeniedException) {
            response.setStatus(403);
        } else if (currentException instanceof AuthenticationException || AuthenticationException.class.isAssignableFrom(currentException.getClass())) {
            response.setStatus(401);
        } else {
            response.setStatus(500);
        }
        String requestedJson = this.getRequestedJson(request);
        if (requestedJson != null && requestedJson.contains("cqrsCommandType")) {
            CqrsCommand command = JsonUtil.fromJson(requestedJson, RequestedCqrsCommand.class);
            command.setFailureMessage(new FailureMessage(currentException));
            ServletServerHttpResponse serverResponse = new ServletServerHttpResponse(response);
            serverResponse.getBody().write(JsonUtil.toJson(command.getCommandResponse()).getBytes());
        } else if (requestedJson != null && requestedJson.contains("cqrsQueryType")) {
            CqrsQuery query = JsonUtil.fromJson(requestedJson, RequestedCqrsQuery.class);
            query.setFailureMessage(new FailureMessage(currentException));
            ServletServerHttpResponse serverResponse = new ServletServerHttpResponse(response);
            serverResponse.getBody().write(JsonUtil.toJson(query.getQueryResponse()).getBytes());
        } else if (requestedJson != null && requestedJson.contains("failureMessageName")) {
            CqrsCommand command = JsonUtil.fromJson(requestedJson, RequestedCqrsCommand.class);
            command.setFailureMessage(new FailureMessage(currentException));
            ServletServerHttpResponse serverResponse = new ServletServerHttpResponse(response);
            serverResponse.getBody().write(JsonUtil.toJson(command.getCommandResponse()).getBytes());
        } else {
            response.setHeader(X_RESULT, "false");
            response.setHeader(X_EXCEPTION_MESSGE, Optional.ofNullable(currentException.getMessage()).orElse("Unknown exception occurred"));
        }
    }

    private String getRequestedJson(HttpServletRequest request) throws IOException {
        if (HttpMethod.valueOf((String)request.getMethod()) == HttpMethod.POST && request.getHeader("Content-Type").contains("application/json")) {
            return IOUtils.toString((InputStream)request.getInputStream(), (String)StandardCharsets.UTF_8.name());
        }
        return null;
    }
}

