/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.spacekeeper.filter;

import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequest;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestBuilder;
import io.naradrama.prologue.util.spacekeeper.filter.SpaceRequestContext;
import io.naradrama.prologue.util.spacekeeper.security.PublicResourceEndPointHolder;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpaceAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(SpaceAuthenticationFilter.class);
    private static final String ROLE_ANONYMOUS = "ROLE_ANONYMOUS";
    private final SpaceRequestBuilder requestBuilder;
    private final PublicResourceEndPointHolder endPointHolder;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.requestBuilder.buildRequest(request);
            SpaceRequest spaceRequest = SpaceRequestContext.getCurrentRequest();
            boolean isPublic = this.endPointHolder.isPublic(request.getRequestURI());
            boolean authorized = this.authorized();
            boolean isAnonymous = this.isAnonymous();
            log.debug("Request URI={}, isPublic={}, permitAllMatch={}", new Object[]{request.getRequestURI(), isPublic, isAnonymous});
            if (!isPublic && !authorized) {
                log.debug("Unauthorized");
                throw new AuthenticationCredentialsNotFoundException("Unauthorized");
            }
            if (!(isPublic || isAnonymous || spaceRequest != null && spaceRequest.hasAuthority())) {
                log.debug("Requested space is not authorized");
                throw new AccessDeniedException("Requested space is not authorized");
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        finally {
            this.requestBuilder.clearRequest();
        }
    }

    private boolean authorized() {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            return false;
        }
        return this.getAuthentication().isAuthenticated();
    }

    private boolean isAnonymous() {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            return false;
        }
        return authentication.getAuthorities().stream().anyMatch(authority -> ROLE_ANONYMOUS.equals(authority.getAuthority()));
    }

    private Authentication getAuthentication() {
        if (SecurityContextHolder.getContext() == null) {
            return null;
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            return null;
        }
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public SpaceAuthenticationFilter(SpaceRequestBuilder requestBuilder, PublicResourceEndPointHolder endPointHolder) {
        this.requestBuilder = requestBuilder;
        this.endPointHolder = endPointHolder;
    }
}

