/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.rolekeeper.filter;

import io.naradrama.prologue.domain.cqrs.command.CqrsCommand;
import io.naradrama.prologue.domain.cqrs.query.CqrsQuery;
import io.naradrama.prologue.domain.drama.AuthorizedRole;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class RoleResourceEndPointHolder {
    private static final Logger log = LoggerFactory.getLogger(RoleResourceEndPointHolder.class);
    private static final String PUBLIC = "isPublic";
    private static final String AUTHORIZED_ROLE_DEFAULT = "value";
    private static final String AUTHORIZED_ROLE_ROLES = "roles";
    private Set<String> publicUrlSet = new HashSet<String>();
    private Map<String, Set<String>> resourceRoleMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> messageRoleMap = new HashMap<String, Set<String>>();

    @EventListener
    public void handleContextRefresh(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map map = requestMappingHandlerMapping.getHandlerMethods();
        map.forEach((mapping, method) -> {
            boolean isPublicMapping = this.parsePublicRole(method.getBeanType().getAnnotations()) || this.parsePublicRole(method.getMethod().getAnnotations());
            HashSet<String> resourceRole = new HashSet<String>();
            resourceRole.addAll(this.parseResourceRole(method.getBeanType().getAnnotations()));
            resourceRole.addAll(this.parseResourceRole(method.getMethod().getAnnotations()));
            HashSet<String> messageRole = new HashSet<String>();
            messageRole.addAll(this.parseMessageRole((HandlerMethod)method));
            mapping.getPatternsCondition().getPatterns().forEach(pattern -> {
                if (isPublicMapping) {
                    log.debug("Authorized role is public, url={}", pattern);
                    this.publicUrlSet.add((String)pattern);
                } else if (!pattern.startsWith("/secure/")) {
                    this.publicUrlSet.add((String)pattern);
                } else {
                    if (resourceRole != null && !resourceRole.isEmpty()) {
                        log.debug("Authorized resource role, url={}, role={}", pattern, (Object)resourceRole);
                        this.resourceRoleMap.put((String)pattern, (Set<String>)resourceRole);
                    }
                    if (messageRole != null && !messageRole.isEmpty()) {
                        log.debug("Authorized message role, url={}, role={}", pattern, (Object)messageRole);
                        this.messageRoleMap.put((String)pattern, (Set<String>)messageRole);
                    }
                }
            });
        });
    }

    public boolean isPublic(String url) {
        if (this.publicUrlSet.contains(url)) {
            return true;
        }
        if (url.endsWith("/")) {
            String alternativeUrl = url.substring(0, url.length() - 1);
            return this.publicUrlSet.contains(alternativeUrl);
        }
        return false;
    }

    public boolean hasResourceRole(String url, Set<String> requestRoles) {
        Set<String> roles = this.findRole(this.resourceRoleMap, url);
        if (roles == null) {
            return true;
        }
        return requestRoles.stream().anyMatch(requestRole -> StringUtils.isNotBlank((CharSequence)requestRole) && roles.contains(requestRole));
    }

    public boolean hasMessageRole(String url, Set<String> requestRoles) {
        Set<String> roles = this.findRole(this.messageRoleMap, url);
        if (roles == null) {
            return true;
        }
        return requestRoles.stream().anyMatch(requestRole -> StringUtils.isNotBlank((CharSequence)requestRole) && roles.contains(requestRole));
    }

    private Set<String> findRole(Map<String, Set<String>> roleMap, String url) {
        String alternativeUrl;
        if (roleMap.containsKey(url)) {
            return roleMap.get(url);
        }
        if (url.endsWith("/") && roleMap.containsKey(alternativeUrl = url.substring(0, url.length() - 1))) {
            return roleMap.get(alternativeUrl);
        }
        return null;
    }

    private boolean parsePublicRole(Annotation[] annotations) {
        return Arrays.stream(annotations).anyMatch(annotation -> {
            if (annotation.annotationType().equals(AuthorizedRole.class)) {
                try {
                    Method annotationMethod = Arrays.stream(annotation.annotationType().getMethods()).filter(method -> method.getName().equals(PUBLIC)).findFirst().orElse(null);
                    return Boolean.parseBoolean(annotationMethod.invoke(annotation, (Object[])null).toString());
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        });
    }

    private Collection<String> parseResourceRole(Annotation[] annotations) {
        HashSet<String> roles = new HashSet<String>();
        Arrays.stream(annotations).anyMatch(annotation -> {
            if (annotation.annotationType().equals(AuthorizedRole.class)) {
                roles.addAll(this.getAnnotationValues((Annotation)annotation, AUTHORIZED_ROLE_DEFAULT));
                roles.addAll(this.getAnnotationValues((Annotation)annotation, AUTHORIZED_ROLE_ROLES));
                return true;
            }
            return false;
        });
        return roles;
    }

    private Collection<String> parseMessageRole(HandlerMethod method) {
        Class<?>[] parameterTypes = method.getMethod().getParameterTypes();
        Class messageClass = Arrays.stream(parameterTypes).filter(parameterType -> CqrsCommand.class.isAssignableFrom((Class<?>)parameterType) || CqrsQuery.class.isAssignableFrom((Class<?>)parameterType)).findFirst().orElse(null);
        if (messageClass == null) {
            return Collections.emptyList();
        }
        HashSet<String> roles = new HashSet<String>();
        Arrays.stream(messageClass.getAnnotations()).anyMatch(annotation -> {
            if (annotation.annotationType().equals(AuthorizedRole.class)) {
                roles.addAll(this.getAnnotationValues((Annotation)annotation, AUTHORIZED_ROLE_DEFAULT));
                roles.addAll(this.getAnnotationValues((Annotation)annotation, AUTHORIZED_ROLE_ROLES));
                return true;
            }
            return false;
        });
        return roles;
    }

    private Collection<String> getAnnotationValues(Annotation annotation, String name) {
        try {
            Method annotationMethod = Arrays.stream(annotation.annotationType().getMethods()).filter(method -> method.getName().equals(name)).findFirst().orElse(null);
            if (annotationMethod == null) {
                Collections.emptyList();
            }
            String[] values = (String[])annotationMethod.invoke((Object)annotation, (Object[])null);
            return Arrays.asList(values);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }
}

