/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.rolekeeper.filter;

import io.naradrama.prologue.util.rolekeeper.filter.RoleResourceEndPointHolder;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class RoleAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RoleAuthenticationFilter.class);
    private static final String ROLE_ANONYMOUS = "ROLE_ANONYMOUS";
    private final RoleResourceEndPointHolder endPointHolder;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        boolean isPublic = this.endPointHolder.isPublic(request.getRequestURI());
        boolean authorized = this.authorized();
        boolean isAnonymous = this.isAnonymous();
        log.debug("Request URI={}, isPublic={}, permitAllMatch={}", new Object[]{request.getRequestURI(), isPublic, isAnonymous});
        if (!isPublic && authorized) {
            HashSet<String> requestRoles = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)request.getHeader("roles"))) {
                List roles = Arrays.stream(request.getHeader("roles").split(",")).map(role -> role.trim()).collect(Collectors.toList());
                requestRoles.addAll(roles);
            }
            if (!this.endPointHolder.hasResourceRole(request.getRequestURI(), requestRoles)) {
                throw new ServletException((Throwable)new IllegalAccessException("Not enough role for requested resource"));
            }
            if (!this.endPointHolder.hasMessageRole(request.getRequestURI(), requestRoles)) {
                throw new ServletException((Throwable)new IllegalAccessException("Not enough role for requested message"));
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean authorized() {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            return false;
        }
        return this.getAuthentication().isAuthenticated();
    }

    private boolean isAnonymous() {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            return false;
        }
        return authentication.getAuthorities().stream().anyMatch(authority -> ROLE_ANONYMOUS.equals(authority.getAuthority()));
    }

    private Authentication getAuthentication() {
        if (SecurityContextHolder.getContext() == null) {
            return null;
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            return null;
        }
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public RoleAuthenticationFilter(RoleResourceEndPointHolder endPointHolder) {
        this.endPointHolder = endPointHolder;
    }
}

