/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.query;

import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.naradrama.prologue.domain.Offset;
import io.naradrama.prologue.util.query.RdbQueryRequest;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class RdbQueryBuilder {
    public static <T> TypedQuery<T> build(RdbQueryRequest request) {
        CriteriaQuery<T> criteriaQuery = RdbQueryBuilder.buildCriteriaQuery(request);
        return request.getEntityManager().createQuery(criteriaQuery);
    }

    public static <T> TypedQuery<T> build(RdbQueryRequest<T> request, Offset offset) {
        CriteriaQuery<T> criteriaQuery = RdbQueryBuilder.buildCriteriaQuery(request, offset);
        return request.getEntityManager().createQuery(criteriaQuery);
    }

    public static <T> TypedQuery<Long> buildForCount(RdbQueryRequest<T> request) {
        CriteriaQuery<Long> criteriaQuery = RdbQueryBuilder.buildCountCriteriaQuery(request);
        return request.getEntityManager().createQuery(criteriaQuery);
    }

    private static <T> CriteriaQuery<T> buildCriteriaQuery(RdbQueryRequest<T> request) {
        CriteriaBuilder builder = request.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(request.getClazz());
        RdbQueryBuilder.processWhereClause(request, criteria);
        return criteria;
    }

    private static <T> CriteriaQuery<T> buildCriteriaQuery(RdbQueryRequest<T> request, Offset offset) {
        CriteriaBuilder builder = request.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(request.getClazz());
        Root<T> root = RdbQueryBuilder.processWhereClause(request, criteria);
        if (offset.ascendingSort()) {
            criteria.orderBy(new Order[]{builder.asc((Expression)root.get(offset.getSortingField()))});
        } else {
            criteria.orderBy(new Order[]{builder.desc((Expression)root.get(offset.getSortingField()))});
        }
        return criteria;
    }

    private static <T> CriteriaQuery<Long> buildCountCriteriaQuery(RdbQueryRequest<T> request) {
        CriteriaBuilder builder = request.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root<T> root = RdbQueryBuilder.processWhereClause(request, criteria);
        criteria.select((Selection)builder.count(root));
        return criteria;
    }

    private static <T> Root<T> processWhereClause(RdbQueryRequest<T> request, CriteriaQuery<?> criteria) {
        Root root = criteria.from(request.getClazz());
        JpaPredicateVisitor visitor = new JpaPredicateVisitor(new Object[0]).defineRoot((From)root);
        Node rootNode = new RSQLParser().parse(request.getQueryString());
        Predicate predicate = (Predicate)rootNode.accept((RSQLVisitor)visitor, (Object)request.getEntityManager());
        criteria.where((Expression)predicate);
        return root;
    }

    @Deprecated
    public static <T> TypedQuery<Long> buildCountQuery(RdbQueryRequest<T> request) {
        return RdbQueryBuilder.buildForCount(request);
    }

    @Deprecated
    public static <T> TypedQuery<T> buildWithPageable(RdbQueryRequest request, Offset offset) {
        return RdbQueryBuilder.build(request, offset);
    }
}

