/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.query;

import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;

public class DocQueryRequest<T> {
    protected String queryString;
    protected Class<T> clazz;
    private String collectionName;
    private MongoTemplate mongoTemplate;

    public DocQueryRequest(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void addQueryStringAndClass(String queryString, Class<T> clazz) {
        this.queryString = queryString;
        this.clazz = clazz;
    }

    public void addCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public T findOne(Query query) {
        return (T)this.mongoTemplate.findOne(query, this.getClazz(), this.collectionName);
    }

    public long count(String collectionName) {
        return this.mongoTemplate.count(new Query(), collectionName);
    }

    public List<T> findAll(Query query) {
        return this.mongoTemplate.find(query, this.getClazz(), this.collectionName);
    }

    public long count(Query query) {
        return this.mongoTemplate.count(query, this.getClazz(), this.collectionName);
    }

    public List<T> findAll(Class<T> clazz, String collectionName) {
        return this.mongoTemplate.findAll(clazz, collectionName);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }
}

