/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.query;

import com.github.rutledgepaulv.qbuilders.conditions.Condition;
import com.github.rutledgepaulv.qbuilders.visitors.ContextualNodeVisitor;
import com.github.rutledgepaulv.qbuilders.visitors.MongoVisitor;
import com.github.rutledgepaulv.rqe.pipes.QueryConversionPipeline;
import io.naradrama.prologue.domain.Offset;
import io.naradrama.prologue.util.query.DocQueryRequest;
import java.util.Objects;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class DocQueryBuilder {
    private static QueryConversionPipeline pipeline = QueryConversionPipeline.defaultPipeline();

    private static Criteria buildCriteria(String queryString, Class<?> clazz) {
        Condition condition = pipeline.apply(queryString, clazz);
        return (Criteria)condition.query((ContextualNodeVisitor)new MongoVisitor());
    }

    public static Query build(DocQueryRequest request) {
        String query = DocQueryBuilder.isEmpty(request.getQueryString());
        Criteria criteria = DocQueryBuilder.buildCriteria(query, request.getClazz());
        return new Query((CriteriaDefinition)criteria);
    }

    public static Query build(DocQueryRequest request, Offset offset) {
        Query query = DocQueryBuilder.build(request);
        query = DocQueryBuilder.fetchOffset(query, offset);
        query = DocQueryBuilder.fetchSort(query, offset);
        return query;
    }

    private static Query fetchOffset(Query query, Offset offset) {
        if (Objects.nonNull(offset) && offset.getOffset() >= 0 && offset.getLimit() != 0) {
            return query.with((Pageable)PageRequest.of((int)offset.page(), (int)offset.getLimit()));
        }
        return query;
    }

    private static Query fetchSort(Query query, Offset offset) {
        if (Objects.nonNull(offset) && Objects.nonNull(offset.getSortingField()) && !offset.getSortingField().isEmpty()) {
            Sort.Direction direction = offset.ascendingSort() ? Sort.Direction.ASC : Sort.Direction.DESC;
            return query.with(Sort.by((Sort.Direction)direction, (String[])new String[]{offset.getSortingField()}));
        }
        return query;
    }

    private static String isEmpty(String queryString) {
        if (queryString.isEmpty() || queryString == null) {
            return "id!=*";
        }
        return queryString;
    }
}

