/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.object;

import io.naradrama.prologue.util.exception.NaraException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class ObjectDiffer {
    private final PropertyUtilsBean propertyBean = BeanUtilsBean.getInstance().getPropertyUtils();
    private Object object1;
    private Object object2;
    private Set<String> properties;

    public ObjectDiffer() {
    }

    public ObjectDiffer(Object object1, Object object2) {
        this();
        this.object1 = object1;
        this.object2 = object2;
    }

    public ObjectDiffer(Object object1, Object object2, Set<String> properties) {
        this(object1, object2);
        this.properties = properties;
    }

    public void setObjects(Object object1, Object object2) {
        this.object1 = object1;
        this.object2 = object2;
    }

    public void setProperties(Set<String> properties) {
        this.properties = properties;
    }

    public void addProperty(String property) {
        if (this.properties == null || this.properties.isEmpty()) {
            this.properties = new HashSet<String>();
        }
        this.properties.add(property);
    }

    public boolean hasDifference() {
        try {
            PropertyDescriptor[] targetPds;
            if (this.object1 == null || this.object2 == null) {
                throw new IllegalArgumentException("The object must not be null");
            }
            if (this.object1.getClass() != this.object2.getClass()) {
                throw new IllegalArgumentException("The objects type must same");
            }
            if (this.isPrimitive(this.object1)) {
                throw new IllegalArgumentException("The objects type must not be primitive");
            }
            if (this.properties == null || this.properties.isEmpty()) {
                return this.isDifferentObjects(this.object1, this.object2);
            }
            for (PropertyDescriptor desc : targetPds = this.propertyBean.getPropertyDescriptors(this.object1.getClass())) {
                if (desc.getName().equals("class") || desc.getName().equals("declaringClass")) continue;
                for (String property : this.properties) {
                    Object objectValue2;
                    Object objectValue1;
                    if (!property.equals(desc.getName()) || !this.isDifferentObjects(objectValue1 = this.propertyBean.getProperty(this.object1, property), objectValue2 = this.propertyBean.getProperty(this.object2, property))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new NaraException("ObjectDiffer failed with: " + e.getMessage());
        }
    }

    public List<String> getDifferences() {
        try {
            PropertyDescriptor[] targetPds;
            ArrayList<String> differentPropertyList = new ArrayList<String>();
            if (this.object1 == null || this.object2 == null) {
                throw new IllegalArgumentException("The object must not be null");
            }
            if (this.object1.getClass() != this.object2.getClass()) {
                throw new IllegalArgumentException("The objects type must same");
            }
            if (this.isPrimitive(this.object1)) {
                throw new IllegalArgumentException("The objects type must not be primitive");
            }
            for (PropertyDescriptor desc : targetPds = this.propertyBean.getPropertyDescriptors(this.object1.getClass())) {
                if (desc.getName().equals("class") || desc.getName().equals("declaringClass")) continue;
                if (this.properties == null || this.properties.isEmpty()) {
                    Object objectValue2;
                    Object objectValue1 = this.propertyBean.getProperty(this.object1, desc.getName());
                    if (!this.isDifferentObjects(objectValue1, objectValue2 = this.propertyBean.getProperty(this.object2, desc.getName()))) continue;
                    differentPropertyList.add(desc.getName());
                    continue;
                }
                for (String property : this.properties) {
                    Object objectValue2;
                    Object objectValue1;
                    if (!property.equals(desc.getName()) || !this.isDifferentObjects(objectValue1 = this.propertyBean.getProperty(this.object1, property), objectValue2 = this.propertyBean.getProperty(this.object2, property))) continue;
                    differentPropertyList.add(property);
                }
            }
            return differentPropertyList;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new NaraException("ObjectDiffer Fail");
        }
    }

    private boolean isDifferentObjects(Object object1, Object object2) {
        try {
            if (object1 == null && object2 != null) {
                return this.isEmpty(object2);
            }
            if (object1 != null && object2 == null) {
                return this.isEmpty(object1);
            }
            if (object1 != null) {
                PropertyDescriptor[] targetPds;
                if (this.isPrimitive(object1) && !object1.equals(object2)) {
                    return true;
                }
                if (object1 instanceof Collection && this.isDifferentForCollection((Collection)object1, (Collection)object2)) {
                    return true;
                }
                if (object1 instanceof Map && this.isDifferentForMap((Map)object1, (Map)object2)) {
                    return true;
                }
                for (PropertyDescriptor desc : targetPds = this.propertyBean.getPropertyDescriptors(object1.getClass())) {
                    Object objectValue2;
                    Object objectValue1;
                    if (desc.getName().equals("class") || desc.getName().equals("declaringClass") || !this.isDifferentObjects(objectValue1 = this.propertyBean.getProperty(object1, desc.getName()), objectValue2 = this.propertyBean.getProperty(object2, desc.getName()))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new NaraException("ObjectDiffer Fail");
        }
    }

    private boolean isDifferentForCollection(Collection collection, Collection collection2) {
        if (collection == null && collection2 != null && !collection2.isEmpty()) {
            return true;
        }
        if (collection2 == null && collection != null && !collection.isEmpty()) {
            return true;
        }
        if (collection != null && collection2 != null) {
            if (collection.isEmpty() && collection2.isEmpty()) {
                return false;
            }
            if (collection.size() != collection2.size()) {
                return true;
            }
            Object generic = collection.iterator().next();
            Iterator it = collection.iterator();
            Iterator it2 = collection2.iterator();
            if (this.isPrimitive(generic)) {
                it = this.sortIterator(collection.iterator());
                it2 = this.sortIterator(collection2.iterator());
            }
            while (it.hasNext() && it2.hasNext()) {
                Object value2;
                Object value1 = it.next();
                if (!this.isDifferentObjects(value1, value2 = it2.next())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDifferentForMap(Map map1, Map map2) {
        if (map1 == null && map2 != null && !map2.isEmpty()) {
            return true;
        }
        if (map2 == null && map1 != null && !map1.isEmpty()) {
            return true;
        }
        if (map1 != null && map2 != null) {
            if (map1.isEmpty() && map2.isEmpty()) {
                return false;
            }
            if (map1.size() != map2.size()) {
                return true;
            }
            Set set = map1.keySet();
            for (Object o : set) {
                String key = (String)o;
                if (!this.isDifferentObjects(map1.get(key), map2.get(key))) continue;
                return true;
            }
        }
        return false;
    }

    private Iterator sortIterator(Iterator iterator) {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        Collections.sort(list);
        return list.iterator();
    }

    private boolean isPrimitive(Object object) {
        return object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Double || object.getClass().isPrimitive();
    }

    private boolean isEmpty(Object object) {
        if (this.isPrimitive(object)) {
            return object.equals("");
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return true;
    }
}

