/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.numeral36;

public class Numeral36 {
    private static final int Decimal36 = 36;

    private Numeral36() {
    }

    public static Numeral36 getInstance() {
        return new Numeral36();
    }

    public String getNextStr36(int int36) {
        return this.getStr36(++int36);
    }

    public String getNextStr36(String str36) {
        if (str36.length() == 1 && str36.equals("z")) {
            throw new RuntimeException("Overflow, z is the last char in one byte value -> " + str36);
        }
        long longValue = this.getLong36(str36);
        return this.getStr36(++longValue);
    }

    public long getLong36(String str36) {
        if (str36 == null || str36.equals("")) {
            throw new RuntimeException("Minus digit is not valid -> " + str36);
        }
        long resultInt = 0L;
        int currentIndex = 0;
        while (currentIndex < str36.length()) {
            char currentChar = str36.charAt(currentIndex);
            int intValue = currentChar < 'a' ? currentChar - 48 : currentChar + 10 - 97;
            int remainCount = str36.length() - ++currentIndex;
            if (remainCount == 0) {
                resultInt += (long)intValue;
                continue;
            }
            resultInt = (long)((double)resultInt + (double)intValue * Math.pow(36.0, remainCount));
        }
        return resultInt;
    }

    public String getStr36(long int36, int formatLength) {
        return this.format(this.getStr36(int36), formatLength);
    }

    public String getStr36(long int36) {
        StringBuilder resultStr = new StringBuilder();
        if (int36 < 0L) {
            throw new RuntimeException("Minus digit is not valid -> " + int36);
        }
        if (int36 < 10L) {
            resultStr.append((char)(int36 + 48L));
        } else {
            while (int36 > 0L) {
                long remain = int36 % 36L;
                char charDigit = remain < 10L ? (char)(remain + 48L) : (char)(remain - 10L + 97L);
                resultStr.insert(0, charDigit);
                int36 /= 36L;
            }
        }
        return resultStr.toString();
    }

    private String format(String str36, int formatLength) {
        int fillCount = formatLength - str36.length();
        if (fillCount < 0) {
            throw new RuntimeException("Formatted length is smaller than str36 length:" + str36);
        }
        if (fillCount == 0) {
            return str36;
        }
        StringBuilder strBuilder = new StringBuilder(formatLength);
        for (int i = 0; i < fillCount; ++i) {
            strBuilder.append("0");
        }
        strBuilder.append(str36);
        return strBuilder.toString();
    }

    public static void main(String[] args) {
        Numeral36 numeral36 = new Numeral36();
        System.out.println(numeral36.getStr36(12L));
        System.out.println(numeral36.getStr36(1201010L));
    }
}

