/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.naradrama.prologue.util.string.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JsonUtil {
    private JsonUtil() {
    }

    public static String toJson(Object target) {
        String result = "";
        ObjectMapper mapper = JsonUtil.getObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        try {
            ObjectWriter writer = mapper.writer().withoutAttribute((Object)"logger");
            return writer.writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return result;
        }
    }

    public static String toPrettyJson(Object target) {
        String result = "";
        ObjectMapper mapper = JsonUtil.getObjectMapper();
        try {
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter().withoutAttribute((Object)"logger");
            return writer.writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return result;
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        Object result = null;
        ObjectMapper mapper = JsonUtil.getObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        try {
            result = mapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    public static <T> List<T> fromJsonList(String json, Class<T> clazz) {
        List results = new ArrayList();
        if (StringUtil.isEmpty((CharSequence)json)) {
            return results;
        }
        ObjectMapper mapper = JsonUtil.getObjectMapper();
        try {
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
            results = (List)mapper.readValue(json, (JavaType)type);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return results;
    }

    public static <T> Set<T> fromJsonSet(String json, Class<T> clazz) {
        Set results = new HashSet();
        ObjectMapper mapper = JsonUtil.getObjectMapper();
        try {
            CollectionType type = mapper.getTypeFactory().constructCollectionType(Set.class, clazz);
            results = (Set)mapper.readValue(json, (JavaType)type);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return results;
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }
}

