/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.util.iso;

import java.util.Locale;

public class CountryUtil {
    public static String[] requestIsoCountryCodes() {
        return Locale.getISOCountries();
    }

    public static String[][] requestIsoCountryCodeNames() {
        String[] countryCodes = CountryUtil.requestIsoCountryCodes();
        String[][] codeNames = new String[countryCodes.length][2];
        int i = 0;
        for (String countryCode : countryCodes) {
            Locale locale = new Locale("", countryCode);
            codeNames[i][0] = locale.getCountry();
            codeNames[i][1] = locale.getDisplayCountry();
            ++i;
        }
        return codeNames;
    }

    public static boolean validCode(String code) {
        String[] countryCodes;
        for (String countryCode : countryCodes = CountryUtil.requestIsoCountryCodes()) {
            if (!countryCode.equals(code)) continue;
            return true;
        }
        return false;
    }

    public static String requestName(String code) {
        if (!CountryUtil.validCode(code)) {
            throw new IllegalArgumentException("Code: " + code);
        }
        Locale locale = new Locale("", code);
        return locale.getDisplayCountry();
    }

    public static void main(String[] args) {
        System.out.println(CountryUtil.validCode("KR"));
        System.out.println(CountryUtil.validCode("kr"));
        System.out.println(CountryUtil.validCode("yy"));
    }
}

