/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.tenant;

import io.naradrama.prologue.domain.tenant.DenizenKey;
import io.naradrama.prologue.domain.tenant.TenantType;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.numeral36.Numeral36;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

public abstract class TenantKey
implements JsonSerializable {
    public static final String HIERARCHY_DELIMITER = ":";
    public static final String MEMBER_DELIMITER = "@";
    private String id;
    private TenantType type;

    public TenantKey(String id, TenantType type) {
        this.id = id;
        this.type = type;
        if (!this.isValidFor(type)) {
            throw new IllegalArgumentException("Invalid key: " + id + " for: " + type.name());
        }
    }

    public TenantKey(TenantKey tenantKey) {
        this.id = tenantKey.getId();
        this.type = tenantKey.getType();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target != null && this.getClass() == target.getClass()) {
            TenantKey key = (TenantKey)target;
            return Objects.equals(this.id, key.getId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.toJson();
    }

    public boolean isValidFor(TenantType tenantType) {
        if (tenantType.isSpace() ? this.id.contains(MEMBER_DELIMITER) : !this.id.contains(MEMBER_DELIMITER)) {
            return false;
        }
        List<String> spaceKeys = this.parseSpaceKey();
        int spaceKeyCount = spaceKeys.size();
        boolean result = false;
        switch (tenantType) {
            case Square: {
                result = spaceKeyCount == 1;
                break;
            }
            case Denizen: {
                result = spaceKeyCount == 1;
                break;
            }
            case Pavilion: {
                result = spaceKeyCount == 2;
                break;
            }
            case Citizen: {
                result = spaceKeyCount == 2;
                break;
            }
            case Cineroom: {
                result = spaceKeyCount == 3;
                break;
            }
            case Audience: {
                result = spaceKeyCount == 3;
            }
        }
        return result;
    }

    protected static String buildSpaceKey(String parentSpaceKey, long childSpaceSequence) {
        StringBuilder builder = new StringBuilder();
        builder.append(parentSpaceKey);
        builder.append(HIERARCHY_DELIMITER);
        builder.append(Numeral36.getInstance().getStr36(childSpaceSequence));
        return builder.toString();
    }

    protected static String buildMemberKey(DenizenKey DenizenKey2, String spaceKey) {
        StringBuilder builder = new StringBuilder();
        builder.append(DenizenKey2.genSequence36());
        builder.append(MEMBER_DELIMITER);
        builder.append(spaceKey);
        return builder.toString();
    }

    protected static String buildMemberKey(String sequence36, String spaceKey) {
        StringBuilder builder = new StringBuilder();
        builder.append(sequence36);
        builder.append(MEMBER_DELIMITER);
        builder.append(spaceKey);
        return builder.toString();
    }

    protected String parseToParentSpaceKey() {
        return this.id.substring(0, this.id.lastIndexOf(HIERARCHY_DELIMITER));
    }

    protected String parseToSpaceKey() {
        if (!this.id.contains(MEMBER_DELIMITER)) {
            return this.id;
        }
        return this.id.substring(this.id.lastIndexOf(MEMBER_DELIMITER) + 1);
    }

    public static String parseToSequence36(String keyWithSequence) {
        if (!keyWithSequence.contains(MEMBER_DELIMITER)) {
            throw new IllegalArgumentException("Invalid member key");
        }
        return keyWithSequence.substring(0, keyWithSequence.indexOf(MEMBER_DELIMITER));
    }

    protected String parseToSequence36() {
        return TenantKey.parseToSequence36(this.id);
    }

    protected List<String> parseSpaceKey() {
        String spaceKeyString = this.parseToSpaceKey();
        StringTokenizer tokenizer = new StringTokenizer(spaceKeyString, HIERARCHY_DELIMITER);
        ArrayList<String> spaceKeys = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            spaceKeys.add(tokenizer.nextToken());
        }
        return spaceKeys;
    }

    public String getId() {
        return this.id;
    }

    public TenantType getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(TenantType type) {
        this.type = type;
    }

    public TenantKey() {
    }
}

