/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.tenant;

import io.naradrama.prologue.domain.tenant.TenantKey;
import io.naradrama.prologue.domain.tenant.TenantType;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class SquareKey
extends TenantKey {
    public SquareKey(String squareId) {
        super(squareId, TenantType.Square);
    }

    public static SquareKey newKey(long squareSequence) {
        String squareKey = String.format("%s", Numeral36.getInstance().getStr36(squareSequence));
        return new SquareKey(squareKey);
    }

    public static SquareKey fromId(String squareId) {
        return new SquareKey(squareId);
    }

    public static SquareKey fromJson(String json) {
        return JsonUtil.fromJson(json, SquareKey.class);
    }

    public static SquareKey sample() {
        long squareSequence = 1L;
        return SquareKey.newKey(squareSequence);
    }

    public static void main(String[] args) {
        System.out.println(SquareKey.sample().toPrettyJson());
    }

    public SquareKey() {
    }
}

