/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.tenant;

import io.naradrama.prologue.domain.tenant.SquareKey;
import io.naradrama.prologue.domain.tenant.TenantKey;
import io.naradrama.prologue.domain.tenant.TenantType;
import io.naradrama.prologue.util.json.JsonUtil;

public class PavilionKey
extends TenantKey {
    public PavilionKey(String pavilionId) {
        super(pavilionId, TenantType.Pavilion);
    }

    public static PavilionKey newKey(SquareKey squareKey, long pavilionSequence) {
        return new PavilionKey(PavilionKey.buildSpaceKey(squareKey.getId(), pavilionSequence));
    }

    public static PavilionKey fromId(String pavilionId) {
        return new PavilionKey(pavilionId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static PavilionKey fromJson(String json) {
        return JsonUtil.fromJson(json, PavilionKey.class);
    }

    public SquareKey genSquareKey() {
        return new SquareKey(this.parseToParentSpaceKey());
    }

    public static PavilionKey sample() {
        long pavilionSequence = 1L;
        return PavilionKey.newKey(SquareKey.sample(), pavilionSequence);
    }

    public static void main(String[] args) {
        System.out.println(PavilionKey.sample().toPrettyJson());
        System.out.println(PavilionKey.sample().genSquareKey());
    }

    public PavilionKey() {
    }
}

