/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.tenant;

import io.naradrama.prologue.domain.tenant.SquareKey;
import io.naradrama.prologue.domain.tenant.TenantKey;
import io.naradrama.prologue.domain.tenant.TenantType;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class DenizenKey
extends TenantKey {
    public DenizenKey(String denizenId) {
        super(denizenId, TenantType.Denizen);
    }

    public static DenizenKey newKey(SquareKey squareKey, long DenizenSequence) {
        String denizenId = String.format("%s%s%s", Numeral36.getInstance().getStr36(DenizenSequence), "@", squareKey.getId());
        return new DenizenKey(denizenId);
    }

    public static DenizenKey fromId(String denizenId) {
        return new DenizenKey(denizenId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static DenizenKey fromJson(String json) {
        return JsonUtil.fromJson(json, DenizenKey.class);
    }

    public String genSequence36() {
        return this.parseToSequence36();
    }

    public SquareKey genSquareKey() {
        return new SquareKey(this.parseToSpaceKey());
    }

    public static DenizenKey sample() {
        long DenizenSequence = 88L;
        return DenizenKey.newKey(SquareKey.sample(), DenizenSequence);
    }

    public static void main(String[] args) {
        System.out.println(DenizenKey.sample().toPrettyJson());
        System.out.println(DenizenKey.sample().genSquareKey());
        System.out.println(DenizenKey.sample().genSequence36());
    }

    public DenizenKey() {
    }
}

