/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.tenant;

import io.naradrama.prologue.domain.tenant.DenizenKey;
import io.naradrama.prologue.domain.tenant.PavilionKey;
import io.naradrama.prologue.domain.tenant.TenantKey;
import io.naradrama.prologue.domain.tenant.TenantType;
import io.naradrama.prologue.util.json.JsonUtil;

public class CitizenKey
extends TenantKey {
    public CitizenKey(String CitizenKey2) {
        super(CitizenKey2, TenantType.Citizen);
    }

    public static CitizenKey newKey(DenizenKey DenizenKey2, PavilionKey pavilionKey) {
        return new CitizenKey(CitizenKey.buildMemberKey(DenizenKey2, pavilionKey.getId()));
    }

    public static CitizenKey fromId(String citizenId) {
        return new CitizenKey(citizenId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static CitizenKey fromJson(String json) {
        return JsonUtil.fromJson(json, CitizenKey.class);
    }

    public DenizenKey genDenizenKey() {
        String denizenId = String.format("%s%s%s", this.genSequence36(), "@", this.genPavilionKey().genSquareKey().getId());
        return DenizenKey.fromId(denizenId);
    }

    public PavilionKey genPavilionKey() {
        return new PavilionKey(this.parseToSpaceKey());
    }

    public String genSequence36() {
        return this.parseToSequence36();
    }

    public static CitizenKey sample() {
        return CitizenKey.newKey(DenizenKey.sample(), PavilionKey.sample());
    }

    public static void main(String[] args) {
        System.out.println(CitizenKey.sample().toPrettyJson());
        System.out.println(CitizenKey.sample().genPavilionKey());
        System.out.println(CitizenKey.sample().genDenizenKey().toPrettyJson());
    }

    public CitizenKey() {
    }
}

