/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.tenant;

import io.naradrama.prologue.domain.tenant.AudienceKey;
import io.naradrama.prologue.domain.tenant.PavilionKey;
import io.naradrama.prologue.domain.tenant.TenantKey;
import io.naradrama.prologue.domain.tenant.TenantType;
import io.naradrama.prologue.util.json.JsonUtil;

public class CineroomKey
extends TenantKey {
    public CineroomKey(String cineroomId) {
        super(cineroomId, TenantType.Cineroom);
    }

    public static CineroomKey newKey(PavilionKey pavilionKey, long cineroomSequence) {
        return new CineroomKey(CineroomKey.buildSpaceKey(pavilionKey.getId(), cineroomSequence));
    }

    public static CineroomKey fromId(String cineroomId) {
        return new CineroomKey(cineroomId);
    }

    public AudienceKey newAudienceKey(String citizenId) {
        return AudienceKey.newKey(citizenId, this.getId());
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static CineroomKey fromJson(String json) {
        return JsonUtil.fromJson(json, CineroomKey.class);
    }

    public static CineroomKey fromKey(String key) {
        return new CineroomKey(key);
    }

    public PavilionKey genPavilionKey() {
        return new PavilionKey(this.parseToParentSpaceKey());
    }

    public static CineroomKey sample() {
        long cineroomSequence = 1L;
        return CineroomKey.newKey(PavilionKey.sample(), cineroomSequence);
    }

    public static void main(String[] args) {
        System.out.println(CineroomKey.sample().toPrettyJson());
        System.out.println(CineroomKey.sample().genPavilionKey().toPrettyJson());
    }

    public CineroomKey() {
    }
}

